/*
 * Decompiled with CFR 0.152.
 */
package erebus.recipes;

import erebus.core.helper.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class EnchantSensitiveRecipe
extends ShapedOreRecipe {
    private int width;
    private int height;

    public EnchantSensitiveRecipe(ItemStack output, Object ... inputs) {
        super(output, inputs);
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.checkMatch(grid, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(grid, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.getInput()[this.width - subX - 1 + subY * this.width] : this.getInput()[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false) && this.checkEnchants((ItemStack)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    Iterator itr = ((ArrayList)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkEnchants(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77942_o() && stack2.func_77942_o()) {
            return Utils.getEnchantments(stack1).equals(Utils.getEnchantments(stack2));
        }
        return stack1.func_77942_o() == stack2.func_77942_o();
    }

    public static EnchantSensitiveRecipe makeRecipe(ItemStack output, Object ... inputs) {
        EnchantSensitiveRecipe recipe = new EnchantSensitiveRecipe(output, inputs);
        recipe.width = 0;
        recipe.height = 0;
        int i = 0;
        if (inputs[i] instanceof String[]) {
            String[] str = (String[])inputs[i++];
            for (int j = 0; j < str.length; ++j) {
                String s1 = str[j];
                ++recipe.height;
                recipe.width = s1.length();
            }
        } else {
            while (inputs[i] instanceof String) {
                String str = (String)inputs[i++];
                ++recipe.height;
                recipe.width = str.length();
            }
        }
        return recipe;
    }
}

