/*
 * Decompiled with CFR 0.152.
 */
package erebus.preserved;

import erebus.api.IPreservableEntityHandler;
import erebus.api.IPreservableEntityRegistry;
import erebus.preserved.PreservedItemsHandler;
import erebus.preserved.PreservedSkeletonHandler;
import erebus.preserved.PreservedSlimeHandler;
import erebus.preserved.PreservedWaspHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;

public class PreservableEntityRegistry
implements IPreservableEntityRegistry {
    private Map<Class<? extends Entity>, EntityDimensions> MAP = new HashMap<Class<? extends Entity>, EntityDimensions>();
    private List<IPreservableEntityHandler> HANDLERS = new ArrayList<IPreservableEntityHandler>();
    public static final PreservableEntityRegistry INSTANCE = new PreservableEntityRegistry();

    private PreservableEntityRegistry() {
        this.registerHandler(new PreservedSkeletonHandler());
        this.registerHandler(new PreservedItemsHandler());
        this.registerHandler(new PreservedSlimeHandler());
        this.registerHandler(new PreservedWaspHandler());
    }

    public void readFile(BufferedReader br, boolean clearMap) {
        if (clearMap) {
            this.MAP.clear();
        }
        try {
            String str;
            while ((str = br.readLine()) != null) {
                if (str.isEmpty() || str.startsWith("#")) continue;
                String[] entry = str.trim().split("=");
                if (entry.length != 2) {
                    throw new IllegalArgumentException("Illegal entry found when reading Entity Dimensions file: " + str);
                }
                String[] dims = entry[1].split(",");
                if (dims.length != 4) {
                    throw new IllegalArgumentException("Illegal entry found when reading Entity Dimensions file: " + str);
                }
                Class<?> cls = Class.forName(entry[0]);
                EntityDimensions dimensions = new EntityDimensions(Float.parseFloat(dims[0].trim()), Float.parseFloat(dims[1].trim()), Float.parseFloat(dims[2].trim()), Float.parseFloat(dims[3].trim()));
                this.MAP.put(cls, dimensions);
            }
        }
        catch (ClassNotFoundException str) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading file", e);
        }
    }

    public void writeConfigFile(File file) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("# entity.class=xOffset, yOffset, zOffset, scale");
            bw.newLine();
            bw.write("# Example:");
            bw.newLine();
            bw.write("# net.minecraft.entity.passive.EntityCow=0.5, 0.125, 0.5, 0.5");
            bw.newLine();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerHandler(IPreservableEntityHandler handler) {
        this.HANDLERS.add(handler);
    }

    @Override
    public void registerEntity(Class<? extends Entity> entityCls, EntityDimensions dimensions) {
        this.MAP.put(entityCls, dimensions);
    }

    @Override
    public EntityDimensions getEntityDimensions(Entity entity) {
        for (IPreservableEntityHandler handler : this.HANDLERS) {
            if (!handler.handlesEntity(entity)) continue;
            return handler.getDimensions(entity);
        }
        EntityDimensions dimensions = EntityDimensions.DEFAULT;
        for (Map.Entry<Class<? extends Entity>, EntityDimensions> entry : this.MAP.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
            dimensions = entry.getValue();
            return dimensions;
        }
        return dimensions;
    }

    @Override
    public boolean canBePreserved(Entity entity) {
        for (IPreservableEntityHandler iPreservableEntityHandler : this.HANDLERS) {
            if (!iPreservableEntityHandler.handlesEntity(entity)) continue;
            return iPreservableEntityHandler.canbePreserved(entity);
        }
        for (Map.Entry entry : this.MAP.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return entity instanceof EntityLivingBase && !(entity instanceof IBossDisplayData);
    }

    public static class EntityDimensions {
        public static final EntityDimensions DEFAULT = new EntityDimensions(0.0f, 0.25f, 0.0f, 0.5f);
        final float xOff;
        final float yOff;
        final float zOff;
        final float scale;

        public EntityDimensions(float xOff, float yOff, float zOff, float scale) {
            this.xOff = xOff;
            this.yOff = yOff;
            this.zOff = zOff;
            this.scale = scale;
        }

        public float getX() {
            return this.xOff;
        }

        public float getY() {
            return this.yOff;
        }

        public float getZ() {
            return this.zOff;
        }

        public float getScale() {
            return this.scale;
        }
    }
}

