/*
 * Decompiled with CFR 0.152.
 */
package erebus.network.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.Erebus;
import erebus.ModBlocks;
import erebus.client.fx.EntityRepellentFX;
import erebus.network.AbstractClientPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityCloudFX;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.particle.EntityHugeExplodeFX;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PacketParticle
extends AbstractClientPacket {
    private int entityId;
    private byte particleType;

    public PacketParticle() {
    }

    public PacketParticle(Entity entity, ParticleType particleType) {
        this.entityId = entity.func_145782_y();
        this.particleType = (byte)particleType.ordinal();
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeInt(this.entityId).writeByte((int)this.particleType);
    }

    @Override
    public void read(ByteBuf buffer) {
        this.entityId = buffer.readInt();
        this.particleType = buffer.readByte();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(World world, EntityClientPlayerMP player) {
        if (this.particleType < 0 || this.particleType >= ParticleType.values.length) {
            return;
        }
        EffectRenderer eff = Minecraft.func_71410_x().field_71452_i;
        Entity e = player.field_70170_p.func_73045_a(this.entityId);
        switch (ParticleType.values[this.particleType]) {
            case BEETLE_LARVA_SQUISH: {
                for (int count = 0; count <= 200; ++count) {
                    eff.func_78873_a((EntityFX)new EntityBreakingFX(player.field_70170_p, e.field_70165_t + (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)e.field_70130_N, e.field_70163_u + player.field_70170_p.field_73012_v.nextDouble() * (double)e.field_70131_O - (double)e.field_70129_M, e.field_70161_v + (player.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)e.field_70130_N, Items.field_151123_aH));
                }
                break;
            }
            case CRUSHROOM_BLAM: {
                for (int a = 0; a < 360; a += 4) {
                    double ang = (double)a * Math.PI / 180.0;
                    eff.func_78873_a((EntityFX)new EntityRepellentFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang)) * 3.0f), e.field_70163_u + 0.1, e.field_70161_v + (double)(MathHelper.func_76134_b((float)((float)ang)) * 3.0f), 0.0f, 0.0f, 0.0f));
                }
                break;
            }
            case TARANTULA_BLAM: {
                for (int a = 0; a < 360; a += 4) {
                    double ang = (double)a * Math.PI / 180.0;
                    eff.func_78873_a((EntityFX)new EntityCloudFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang)) * 3.0f), e.field_70163_u, e.field_70161_v + (double)(MathHelper.func_76134_b((float)((float)ang)) * 3.0f), (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.5, 0.1, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.5));
                }
                break;
            }
            case ANTLION_BLAM: {
                for (int a = 0; a < 360; a += 4) {
                    double ang = (double)a * Math.PI / 180.0;
                    for (int count = 0; count <= 20; ++count) {
                        eff.func_78873_a((EntityFX)new EntityDiggingFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 3.5, e.field_70163_u + 0.5, e.field_70161_v + (double)MathHelper.func_76134_b((float)((float)ang)) * 3.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.8, 0.0, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.8, ModBlocks.ghostSand, 0));
                    }
                    eff.func_78873_a((EntityFX)new EntityCloudFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 4.5, e.field_70163_u, e.field_70161_v + (double)MathHelper.func_76134_b((float)((float)ang)) * 4.5, (double)(-MathHelper.func_76126_a((float)((float)ang)) * 1.0f), 0.1, (double)(MathHelper.func_76134_b((float)((float)ang)) * 1.0f)));
                }
                break;
            }
            case BOSS_DEATH: {
                float f = (e.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 8.0f;
                float f1 = (e.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 4.0f;
                float f2 = (e.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 8.0f;
                eff.func_78873_a((EntityFX)new EntityHugeExplodeFX(player.field_70170_p, e.field_70165_t + (double)f, e.field_70163_u + 2.0 + (double)f1, e.field_70161_v + (double)f2, 0.0, 0.0, 0.0));
                break;
            }
            case ANTLION_RUMBLE: {
                for (int a = 0; a < 360; a += 4) {
                    double ang = (double)a * Math.PI / 180.0;
                    eff.func_78873_a((EntityFX)new EntityDiggingFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 3.5, e.field_70163_u + 0.125, e.field_70161_v + (double)MathHelper.func_76134_b((float)((float)ang)) * 3.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.8, 0.3, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.8, ModBlocks.ghostSand, 0));
                }
                break;
            }
            case HAMMER_BLAM: {
                for (int a = 0; a < 360; a += 4) {
                    double ang = (double)a * Math.PI / 180.0;
                    for (int count = 0; count <= 4; ++count) {
                        eff.func_78873_a((EntityFX)new EntityFireworkSparkFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang)) * 1.0f * (float)count) * 0.5, e.field_70163_u - 1.0, e.field_70161_v + (double)(MathHelper.func_76134_b((float)((float)ang)) * 1.0f * (float)count) * 0.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.5, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.5, eff));
                    }
                    eff.func_78873_a((EntityFX)new EntityCloudFX(player.field_70170_p, e.field_70165_t + (double)(-MathHelper.func_76126_a((float)((float)ang)) * 2.0f), e.field_70163_u - 1.0, e.field_70161_v + (double)(MathHelper.func_76134_b((float)((float)ang)) * 2.0f), (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.5, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.5));
                }
                break;
            }
            case GAS_VENT_SWAMP: {
                for (double yy = e.field_70163_u; yy < e.field_70163_u + 2.0; yy += 0.5) {
                    double d0 = e.field_70165_t - (double)0.075f;
                    double d1 = yy;
                    double d2 = e.field_70161_v - (double)0.075f;
                    double d3 = e.field_70165_t + (double)0.075f;
                    double d4 = e.field_70161_v + (double)0.075f;
                    double d5 = e.field_70165_t;
                    double d6 = yy + 0.25;
                    double d7 = e.field_70161_v;
                    Erebus.proxy.spawnCustomParticle("swampflame", world, d0, d1, d2, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("swampflame", world, d0, d1, d4, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("swampflame", world, d3, d1, d2, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("swampflame", world, d3, d1, d4, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("swampflame", world, d5, d6, d7, 0.0, 0.05, 0.0);
                }
                break;
            }
            case GAS_VENT_VOLCANIC: {
                for (double yy = e.field_70163_u; yy < e.field_70163_u + 2.0; yy += 0.5) {
                    double d0 = e.field_70165_t - (double)0.075f;
                    double d1 = yy;
                    double d2 = e.field_70161_v - (double)0.075f;
                    double d3 = e.field_70165_t + (double)0.075f;
                    double d4 = e.field_70161_v + (double)0.075f;
                    double d5 = e.field_70165_t;
                    double d6 = yy + 0.25;
                    double d7 = e.field_70161_v;
                    Erebus.proxy.spawnCustomParticle("flame", world, d0, d1, d2, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("flame", world, d0, d1, d4, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("flame", world, d3, d1, d2, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("flame", world, d3, d1, d4, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("flame", world, d5, d6, d7, 0.0, 0.05, 0.0);
                }
                break;
            }
            case SPORE_JET: {
                for (double yy = e.field_70163_u; yy < e.field_70163_u + 2.0; yy += 0.5) {
                    double d0 = e.field_70165_t - (double)0.075f;
                    double d1 = yy;
                    double d2 = e.field_70161_v - (double)0.075f;
                    double d3 = e.field_70165_t + (double)0.075f;
                    double d4 = e.field_70161_v + (double)0.075f;
                    double d5 = e.field_70165_t;
                    double d6 = yy + 0.25;
                    double d7 = e.field_70161_v;
                    Erebus.proxy.spawnCustomParticle("spell", world, d0, d1, d2, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("spell", world, d0, d1, d4, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("spell", world, d3, d1, d2, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("spell", world, d3, d1, d4, 0.0, 0.05, 0.0);
                    Erebus.proxy.spawnCustomParticle("spell", world, d5, d6, d7, 0.0, 0.05, 0.0);
                }
                break;
            }
        }
    }

    public static enum ParticleType {
        BEETLE_LARVA_SQUISH,
        SPRAY_CAN,
        CRUSHROOM_BLAM,
        TARANTULA_BLAM,
        BOSS_DEATH,
        ANTLION_BLAM,
        ANTLION_RUMBLE,
        HAMMER_BLAM,
        GAS_VENT_SWAMP,
        GAS_VENT_VOLCANIC,
        SPORE_JET;

        static final ParticleType[] values;

        static {
            values = ParticleType.values();
        }
    }
}

