/*
 * Decompiled with CFR 0.152.
 */
package erebus.network.client;

import cpw.mods.fml.common.network.ByteBufUtils;
import erebus.core.helper.Utils;
import erebus.network.AbstractClientPacket;
import erebus.network.ByteBufHelper;
import erebus.tileentity.TileEntityJarOHoney;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class PacketJarOHoney
extends AbstractClientPacket {
    private int x;
    private int y;
    private int z;
    private FluidStack fluid;
    private String name;

    public PacketJarOHoney() {
    }

    public PacketJarOHoney(int x, int y, int z, FluidStack fluid, String name) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.fluid = fluid;
        this.name = name;
    }

    @Override
    protected void handle(World world, EntityClientPlayerMP player) {
        TileEntityJarOHoney tile = Utils.getTileEntity((IBlockAccess)world, this.x, this.y, this.z, TileEntityJarOHoney.class);
        if (tile != null) {
            tile.tank.setFluid(this.fluid);
            tile.setOwner(this.name);
        }
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufHelper.writeFluidStack(this.fluid, buffer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
    }

    @Override
    public void read(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.fluid = ByteBufHelper.readFluidStack(buffer);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }
}

