/*
 * Decompiled with CFR 0.152.
 */
package erebus.network;

import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.network.AbstractPacket;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Field;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketPipeline {
    private static PacketPipeline instance;
    private FMLEventChannel eventDrivenChannel;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private final TByteObjectHashMap<Class<? extends AbstractPacket>> idToPacket = new TByteObjectHashMap();
    private final TObjectByteHashMap<Class<? extends AbstractPacket>> packetToId = new TObjectByteHashMap();

    public static void initializePipeline() {
        if (instance != null) {
            throw new RuntimeException("Packet pipeline has already been registered!");
        }
        instance = new PacketPipeline();
        instance.load();
    }

    private void load() {
        this.eventDrivenChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("erebus");
        this.eventDrivenChannel.register((Object)this);
        try {
            Class cls;
            Field channelField = FMLEventChannel.class.getDeclaredField("channels");
            channelField.setAccessible(true);
            this.channels = (EnumMap)channelField.get(this.eventDrivenChannel);
            int id = -1;
            ClassPath path = ClassPath.from((ClassLoader)PacketPipeline.class.getClassLoader());
            for (ClassPath.ClassInfo clsInfo : path.getTopLevelClasses("erebus.network.client")) {
                cls = clsInfo.load();
                if (cls.getName().endsWith("__")) continue;
                this.registerPacket(++id, cls);
            }
            for (ClassPath.ClassInfo clsInfo : path.getTopLevelClasses("erebus.network.server")) {
                cls = clsInfo.load();
                if (cls.getName().endsWith("__")) continue;
                this.registerPacket(++id, cls);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void registerPacket(int id, Class<? extends AbstractPacket> cls) {
        this.idToPacket.put((byte)id, cls);
        this.packetToId.put(cls, (byte)id);
    }

    private FMLProxyPacket writePacket(AbstractPacket packet) {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeByte((int)this.packetToId.get(packet.getClass()));
        packet.write(buffer);
        return new FMLProxyPacket(buffer, "erebus");
    }

    private void readPacket(FMLProxyPacket fmlPacket, Side side) {
        ByteBuf buffer = fmlPacket.payload();
        try {
            AbstractPacket packet = (AbstractPacket)((Class)this.idToPacket.get(buffer.readByte())).newInstance();
            packet.read(buffer.slice());
            switch (side) {
                case CLIENT: {
                    packet.handle(Side.CLIENT, this.getClientWorld(), this.getClientPlayer());
                    break;
                }
                case SERVER: {
                    packet.handle(Side.SERVER, ((NetHandlerPlayServer)fmlPacket.handler()).field_147369_b.field_70170_p, (EntityPlayer)((NetHandlerPlayServer)fmlPacket.handler()).field_147369_b);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public void onClientPacketReceived(FMLNetworkEvent.ClientCustomPacketEvent e) {
        this.readPacket(e.packet, Side.CLIENT);
    }

    @SubscribeEvent
    public void onServerPacketReceived(FMLNetworkEvent.ServerCustomPacketEvent e) {
        this.readPacket(e.packet, Side.SERVER);
    }

    public static void sendToAll(AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToPlayer(EntityPlayer player, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToAllAround(int dimension, double x, double y, double z, double range, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToAllAround(Entity entity, double range, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, range));
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToAllAround(TileEntity tile, double range, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, range));
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToDimension(int dimension, AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static void sendToServer(AbstractPacket packet) {
        FMLEmbeddedChannel channel = PacketPipeline.instance.channels.get(Side.CLIENT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channel.writeAndFlush((Object)instance.writePacket(packet)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

