/*
 * Decompiled with CFR 0.152.
 */
package erebus.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModTabs;
import erebus.entity.EntityExtractedBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPane;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;

public class ItemExtractor
extends Item {
    public ItemExtractor() {
        this.func_77625_d(1);
        this.func_77656_e(128);
        this.func_77637_a(ModTabs.gears);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        list.add(StatCollector.func_74838_a((String)"tooltip.erebus.extractor"));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public int func_77626_a(ItemStack stack) {
        float x;
        float f = x = this.hasTag(stack) ? stack.func_77978_p().func_74760_g("blockHardness") * 30.0f : 0.0f;
        if (x >= 150.0f) {
            x = 150.0f;
        }
        return (int)x;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        Block block;
        if (this.hasTag(stack) && stack.func_77978_p().func_74762_e("coolDown") <= 0) {
            this.getBlockInfo(world, player, stack);
        }
        if (this.hasTag(stack) && (block = Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID"))) != null) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int count) {
        this.resetStats(stack);
    }

    public void getBlockInfo(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.hasTag(stack)) {
            Vec3 vec3 = player.func_70040_Z().func_72432_b();
            double targetX = player.field_70165_t;
            double targetY = player.field_70163_u + (double)player.func_70047_e() - (double)0.1f;
            double targetZ = player.field_70161_v;
            for (int range = 0; world.func_147437_c(MathHelper.func_76128_c((double)targetX), MathHelper.func_76128_c((double)targetY), MathHelper.func_76128_c((double)targetZ)) && range <= 15; ++range) {
                if (world.func_147437_c(MathHelper.func_76128_c((double)(targetX += vec3.field_72450_a)), MathHelper.func_76128_c((double)(targetY += vec3.field_72448_b)), MathHelper.func_76128_c((double)(targetZ += vec3.field_72449_c)))) continue;
                stack.func_77978_p().func_74768_a("targetX", MathHelper.func_76128_c((double)targetX));
                stack.func_77978_p().func_74768_a("targetY", MathHelper.func_76128_c((double)targetY));
                stack.func_77978_p().func_74768_a("targetZ", MathHelper.func_76128_c((double)targetZ));
                stack.func_77978_p().func_74768_a("blockID", Block.func_149682_b((Block)world.func_147439_a(MathHelper.func_76128_c((double)targetX), MathHelper.func_76128_c((double)targetY), MathHelper.func_76128_c((double)targetZ))));
                stack.func_77978_p().func_74768_a("blockMeta", world.func_72805_g(MathHelper.func_76128_c((double)targetX), MathHelper.func_76128_c((double)targetY), MathHelper.func_76128_c((double)targetZ)));
                Block block = Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID"));
                if (block == null) continue;
                stack.func_77978_p().func_74776_a("blockHardness", block.func_149712_f(world, MathHelper.func_76128_c((double)targetX), MathHelper.func_76128_c((double)targetY), MathHelper.func_76128_c((double)targetZ)));
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        Block block;
        if (!world.field_72995_K && this.hasTag(stack) && (block = Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID"))) != null && this.canExtract(block)) {
            this.extractBlock(stack, world, player);
        }
        this.resetStats(stack);
        stack.func_77972_a(1, (EntityLivingBase)player);
        return stack;
    }

    protected void extractBlock(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityExtractedBlock entityExtractedBlock = new EntityExtractedBlock(world);
            int targetX = stack.func_77978_p().func_74762_e("targetX");
            int targetY = stack.func_77978_p().func_74762_e("targetY");
            int targetZ = stack.func_77978_p().func_74762_e("targetZ");
            world.func_147468_f(targetX, targetY, targetZ);
            entityExtractedBlock.func_70012_b((double)targetX + 0.5, targetY, (double)targetZ + 0.5, 0.0f, 0.0f);
            entityExtractedBlock.setBlock(Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID")), stack.func_77978_p().func_74762_e("blockMeta"));
            entityExtractedBlock.setHeading(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            world.func_72838_d((Entity)entityExtractedBlock);
        }
    }

    private boolean canExtract(Block block) {
        return !(block instanceof BlockContainer) && !(block instanceof BlockFluidBase) && !(block instanceof BlockPane) && block != Block.func_149684_b((String)"bedrock") && block.func_149753_y() - block.func_149704_x() >= (double)0.7f && block.func_149693_C() - block.func_149706_B() >= (double)0.7f && block.func_149669_A() - block.func_149665_z() >= (double)0.7f;
    }

    public void resetStats(ItemStack stack) {
        stack.func_77978_p().func_74768_a("blockID", 0);
        stack.func_77978_p().func_74768_a("coolDown", 20);
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int aNumber, boolean aBoolean) {
        if (this.hasTag(stack) && stack.func_77978_p().func_74762_e("coolDown") >= 0) {
            stack.func_77978_p().func_74768_a("coolDown", stack.func_77978_p().func_74762_e("coolDown") - 1);
        }
    }
}

