/*
 * Decompiled with CFR 0.152.
 */
package erebus.item;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.item.ItemMaterials;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemErebusFood
extends ItemFood {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    private static void registerPotionEffect() {
        try {
            Field f = ReflectionHelper.findField(PotionHelper.class, (String[])new String[]{"potionRequirements", "field_77927_l"});
            f.setAccessible(true);
            HashMap potionRequirements = (HashMap)f.get(null);
            potionRequirements.put(Potion.field_76430_j.func_76396_c(), "0 & 1 & !2 & 3");
            Field f2 = ReflectionHelper.findField(PotionHelper.class, (String[])new String[]{"potionAmplifiers", "field_77928_m"});
            f2.setAccessible(true);
            HashMap potionAmplifiers = (HashMap)f2.get(null);
            potionAmplifiers.put(Potion.field_76430_j.func_76396_c(), "5");
            Field f3 = ReflectionHelper.findField(Potion.class, (String[])new String[]{"liquidColor", "field_76414_N"});
            f3.setAccessible(true);
            f3.set(Potion.field_76430_j, 2293580);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ItemErebusFood() {
        super(3, 0.5f, false);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(ModTabs.items);
    }

    public PotionEffect getPotionEffect(ItemStack is, World world, EntityPlayer player) {
        switch (FoodType.values()[is.func_77960_j()]) {
            case BEETLE_LARVA_RAW: {
                return new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 2);
            }
            case MELONADE_SPARKLY: {
                return new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0);
            }
            case LARVAE_ON_STICK: {
                return new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 1);
            }
            case TITAN_CHOP_COOKED: {
                return new PotionEffect(Potion.field_76420_g.field_76415_H, 600, 1);
            }
        }
        return null;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        switch (FoodType.values()[stack.func_77960_j()]) {
            case MELONADE_SPARKLY: 
            case MELONADE: {
                return EnumAction.drink;
            }
        }
        return EnumAction.eat;
    }

    public int func_150905_g(ItemStack stack) {
        return FoodType.values()[stack.func_77960_j()].getHealAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return FoodType.values()[stack.func_77960_j()].getSaturationModifier();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        FoodType type = FoodType.values()[stack.func_77960_j()];
        --stack.field_77994_a;
        player.func_71024_bL().func_151686_a((ItemFood)this, stack);
        String sound = type == FoodType.CABBAGE ? "erebus:cabbagefart" : "random.burp";
        float volume = type == FoodType.CABBAGE ? 1.0f : 0.5f;
        world.func_72956_a((Entity)player, sound, volume, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.func_77849_c(stack, world, player);
        return this.hasContainerItem(stack) ? this.getContainerItem(stack) : stack;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        PotionEffect effect = this.getPotionEffect(stack, world, player);
        if (!world.field_72995_K && effect != null) {
            player.func_70690_d(effect);
        }
        if (!world.field_72995_K && stack.func_77960_j() == FoodType.PRICKLY_PAIR_RAW.ordinal()) {
            player.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[FoodType.values().length];
        int i = 0;
        for (FoodType type : FoodType.values()) {
            this.icons[i++] = reg.func_94245_a("erebus:food_" + type.toString().toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return null;
        }
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < FoodType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "_" + FoodType.values()[stack.func_77960_j()].toString().toLowerCase();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        switch (FoodType.values()[stack.func_77960_j()]) {
            case LARVAE_ON_STICK: {
                return new ItemStack(Items.field_151055_y);
            }
            case BAMBOO_SOUP: {
                return new ItemStack(Items.field_151054_z);
            }
            case MELONADE_SPARKLY: 
            case MELONADE: {
                return ItemMaterials.DATA.SMOOTHIE_GLASS.makeStack();
            }
            case TITAN_STEW_COOKED: {
                return ItemMaterials.DATA.STEW_POT.makeStack();
            }
        }
        return null;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getContainerItem(stack) != null;
    }

    public int getItemStackLimit(ItemStack stack) {
        return !this.hasContainerItem(stack) ? 64 : 1;
    }

    public String func_150896_i(ItemStack stack) {
        return stack != null && stack.func_77960_j() == FoodType.GRASSHOPPER_LEG_RAW.ordinal() ? "+0+1-2+3&4-4+13" : super.func_150896_i(stack);
    }

    public boolean func_150892_m(ItemStack stack) {
        return stack != null && stack.func_77960_j() == FoodType.GRASSHOPPER_LEG_RAW.ordinal();
    }

    static {
        ItemErebusFood.registerPotionEffect();
    }

    public static enum FoodType {
        BEETLE_LARVA_RAW(1, 0.1f),
        BEETLE_LARVA_COOKED(3, 0.4f),
        GRASSHOPPER_LEG_RAW(1, 0.1f),
        GRASSHOPPER_LEG_COOKED(4, 0.4f),
        TARANTULA_LEG_RAW(1, 0.1f),
        TARANTULA_LEG_COOKED(5, 0.4f),
        BAMBOO_SOUP(4, 0.3f),
        MELONADE(3, 0.2f),
        MELONADE_SPARKLY(5, 0.4f),
        LARVAE_ON_STICK(9, 0.5f),
        HONEY_SANDWICH(6, 0.6f),
        DARK_FRUIT(2, 0.3f),
        TITAN_CHOP_RAW(4, 0.3f),
        TITAN_CHOP_COOKED(8, 0.8f),
        SWAMPBERRIES(1, 0.1f),
        CABBAGE(1, 0.3f),
        TITAN_STEW_COOKED(20, 4.0f),
        PRICKLY_PAIR_RAW(3, 0.3f),
        PRICKLY_PAIR_COOKED(4, 0.5f);

        private final int healAmount;
        private final float saturationModifier;

        private FoodType(int healAmount, float saturationModifier) {
            this.healAmount = healAmount;
            this.saturationModifier = saturationModifier;
        }

        public float getSaturationModifier() {
            return this.saturationModifier;
        }

        public int getHealAmount() {
            return this.healAmount;
        }

        public ItemStack makeStack() {
            return this.makeStack(1);
        }

        public ItemStack makeStack(int size) {
            return new ItemStack(ModItems.food, size, this.ordinal());
        }
    }
}

