/*
 * Decompiled with CFR 0.152.
 */
package erebus.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModTabs;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemBowMaxSpeed
extends ItemBow {
    private final int weaponEnchantibility;
    public static final String[] bowAnimationIcon = new String[]{"_standby", "_pulling_0", "_pulling_1", "_pulling_2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemBowMaxSpeed() {
        this.func_77625_d(1);
        this.func_77656_e(301);
        this.weaponEnchantibility = 0;
        this.func_77637_a(ModTabs.gears);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a("erebus:max_speed_bow_standby");
        this.iconArray = new IIcon[bowAnimationIcon.length];
        for (int iconIndex = 0; iconIndex < this.iconArray.length; ++iconIndex) {
            this.iconArray[iconIndex] = icon.func_94245_a("erebus:max_speed_bow" + bowAnimationIcon[iconIndex]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int time = stack.func_77988_m() - useRemaining;
        if (usingItem != null) {
            if (time >= 4) {
                return this.func_94599_c(3);
            }
            if (time > 2) {
                return this.func_94599_c(2);
            }
            if (time > 0) {
                return this.func_94599_c(1);
            }
        }
        return this.field_77791_bV;
    }

    public IIcon func_94599_c(int iconIndex) {
        return this.iconArray[iconIndex];
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            ArrowNockEvent event = new ArrowNockEvent(player, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return event.result;
            }
            if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Items.field_151032_g) || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0) {
                player.func_71008_a(stack, this.func_77626_a(stack));
            }
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int ticks = 72000 - count;
        int speed = 4;
        if (ticks > speed) {
            player.func_71034_by();
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int inUseCount) {
        boolean canShoot;
        float pullSpeedModifier = 5.0f;
        float speedModifier = 1.5f;
        float soundPitchModifier = 1.0f;
        int minRelease = 0;
        int maxUseDuration = 72000 - inUseCount;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, maxUseDuration);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        maxUseDuration = event.charge;
        boolean bl = canShoot = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        if (canShoot || player.field_71071_by.func_146028_b(Items.field_151032_g)) {
            int punchEnchant;
            int powerEnchant;
            float power = (float)maxUseDuration / pullSpeedModifier;
            power = (power * power + power * 2.0f) / 4.0f;
            if (maxUseDuration < minRelease || (double)power < 0.1) {
                return;
            }
            if (power > 1.0f) {
                power = 1.0f;
            }
            EntityArrow entityArrow = new EntityArrow(world, (EntityLivingBase)player, (power *= speedModifier) * 2.0f);
            if (power >= 1.0f) {
                entityArrow.func_70243_d(true);
            }
            if ((powerEnchant = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                entityArrow.func_70239_b(entityArrow.func_70242_d() + (double)powerEnchant + 0.5);
            }
            if ((punchEnchant = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                entityArrow.func_70240_a(punchEnchant * 2);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                entityArrow.func_70015_d(200);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, soundPitchModifier * (1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.3f));
            if (canShoot) {
                entityArrow.field_70251_a = 2;
            } else {
                entityArrow.field_70251_a = 1;
                player.field_71071_by.func_146026_a(Items.field_151032_g);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityArrow);
            }
        }
    }

    public ItemStack onFoodEaten(ItemStack is, World world, EntityPlayer player) {
        return is;
    }

    public int func_77626_a(ItemStack is) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack is) {
        return EnumAction.bow;
    }

    public int func_77619_b() {
        return this.weaponEnchantibility;
    }

    public boolean isBookEnchantable(ItemStack is, ItemStack book) {
        return false;
    }

    public boolean hasEffect(ItemStack is, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack is) {
        return EnumRarity.rare;
    }
}

