/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.ModBlocks;
import erebus.entity.EntityWorkerBee;
import erebus.entity.ai.EntityAIFindFlower;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ChunkCoordinates;

public class EntityAIPolinate
extends EntityAIFindFlower {
    public EntityAIPolinate(EntityLiving entity, int pollinateSpeed) {
        super(entity, null, 0, pollinateSpeed);
    }

    @Override
    protected boolean canPolinate(Block blockID, int blockMeta) {
        if (blockID == null) {
            return false;
        }
        return blockID == ModBlocks.stiga;
    }

    @Override
    protected boolean isEntityReady() {
        return true;
    }

    @Override
    protected void moveToLocation() {
        EntityWorkerBee bee = (EntityWorkerBee)this.entity;
        if ((double)this.flowerY > bee.field_70121_D.field_72338_b - 1.0) {
            bee.field_70163_u += 1.0;
        }
        bee.setBeePollinating(true);
        bee.setBeeFlying(false);
        bee.currentFlightTarget = new ChunkCoordinates(this.flowerX, this.flowerY, this.flowerZ);
        bee.flyToTarget();
    }

    @Override
    protected void prepareToPollinate() {
    }

    @Override
    protected void pollinationInterupted() {
        EntityWorkerBee bee = (EntityWorkerBee)this.entity;
        bee.setBeePollinating(false);
        bee.setBeeFlying(true);
        bee.flyAbout();
    }

    @Override
    protected void afterPollination() {
        EntityWorkerBee bee = (EntityWorkerBee)this.entity;
        if (bee.getNectarPoints() < 127) {
            bee.setNectarPoints(bee.getNectarPoints() + 2);
        }
        if (bee.getTameState() == 0) {
            bee.setBeePollinating(false);
            bee.setBeeFlying(true);
            bee.flyAbout();
        } else if (bee.getTameState() == 1) {
            bee.setBeePollinating(false);
            bee.setBeeCollecting(true);
        }
    }
}

