/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.core.helper.Spiral;
import erebus.core.helper.Utils;
import erebus.entity.EntityBlackAnt;
import java.awt.Point;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public abstract class EntityAIAntsBlock
extends EntityAIBase {
    private static final int CHECKS_PER_TICK = 10;
    private final int EAT_SPEED;
    protected final EntityLiving entity;
    private final int maxGrowthMetadata;
    private final Block block;
    private final ItemStack seed;
    private boolean hasTarget;
    public int cropX;
    public int cropY;
    public int cropZ;
    private int spiralIndex;
    private int eatTicks;
    private static final List<Point> spiral = new Spiral(8, 8).spiral();

    public EntityAIAntsBlock(EntityLiving entity, Block block, int maxGrowthMetadata, ItemStack seed, double moveSpeed, int eatSpeed) {
        this.entity = entity;
        this.maxGrowthMetadata = maxGrowthMetadata;
        this.block = block;
        this.seed = seed;
        this.hasTarget = false;
        this.spiralIndex = 0;
        this.EAT_SPEED = eatSpeed * 20;
    }

    public EntityAIAntsBlock(EntityAnimal entity, Block block, int maxGrowthMetadata, float moveSpeed, int eatSpeed) {
        this((EntityLiving)entity, block, maxGrowthMetadata, null, moveSpeed, eatSpeed);
    }

    public boolean func_75250_a() {
        return this.entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
    }

    public boolean func_75253_b() {
        return !this.entity.func_70631_g_();
    }

    public void func_75246_d() {
        EntityBlackAnt blackAnt = (EntityBlackAnt)this.entity;
        if (!this.func_75253_b()) {
            return;
        }
        int xCoord = blackAnt.getDropPointX();
        int yCoord = blackAnt.getDropPointY();
        int zCoord = blackAnt.getDropPointZ();
        for (int i = 0; i < 10; ++i) {
            boolean flag;
            if (!this.hasTarget) {
                this.increment();
                Point p = this.getNextPoint();
                for (int y = -2; y < 1; ++y) {
                    if (!this.canEatBlock(this.entity.field_70170_p.func_147439_a(xCoord + p.x, yCoord + y, zCoord + p.y), this.entity.field_70170_p.func_72805_g(xCoord + p.x, yCoord + y, zCoord + p.y))) continue;
                    this.cropX = xCoord + p.x;
                    this.cropY = yCoord + y;
                    this.cropZ = zCoord + p.y;
                    this.hasTarget = true;
                }
                continue;
            }
            if (!this.isEntityReady()) continue;
            this.moveToLocation();
            this.entity.func_70671_ap().func_75650_a((double)this.cropX + 0.5, (double)this.cropY + 0.5, (double)this.cropZ + 0.5, 30.0f, 8.0f);
            AxisAlignedBB blockbounds = this.getBlockAABB(this.cropX, this.cropY, this.cropZ);
            boolean bl = flag = this.entity.field_70121_D.field_72337_e >= blockbounds.field_72338_b && this.entity.field_70121_D.field_72338_b <= blockbounds.field_72337_e && this.entity.field_70121_D.field_72336_d >= blockbounds.field_72340_a && this.entity.field_70121_D.field_72340_a <= blockbounds.field_72336_d && this.entity.field_70121_D.field_72334_f >= blockbounds.field_72339_c && this.entity.field_70121_D.field_72339_c <= blockbounds.field_72334_f;
            if (flag) {
                this.prepareToEat();
                ++this.eatTicks;
                if (!this.canEatBlock(this.entity.field_70170_p.func_147439_a(this.cropX, this.cropY, this.cropZ), this.entity.field_70170_p.func_72805_g(this.cropX, this.cropY, this.cropZ))) {
                    this.hasTarget = false;
                } else if (this.EAT_SPEED <= this.eatTicks) {
                    if (this.seed != null) {
                        Utils.dropStack(this.entity.field_70170_p, this.cropX, this.cropY, this.cropZ, this.seed.func_77946_l());
                    }
                    this.hasTarget = false;
                    this.eatTicks = 0;
                    this.afterEaten();
                }
            }
            if (flag || this.eatTicks <= 0) continue;
            this.eatingInterupted();
            this.hasTarget = false;
            this.eatTicks = 0;
        }
    }

    private void increment() {
        ++this.spiralIndex;
        if (this.spiralIndex >= spiral.size()) {
            this.spiralIndex = 0;
        }
    }

    private Point getNextPoint() {
        return spiral.get(this.spiralIndex);
    }

    public Block getTargetBlock() {
        return this.entity.field_70170_p.func_147439_a(this.cropX, this.cropY, this.cropZ);
    }

    protected boolean canEatBlock(Block block, int meta) {
        return block == this.block && meta == this.maxGrowthMetadata;
    }

    protected abstract boolean isEntityReady();

    protected abstract void moveToLocation();

    protected abstract void prepareToEat();

    protected abstract void eatingInterupted();

    protected abstract void afterEaten();

    protected AxisAlignedBB getBlockAABB(int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)this.cropX, (double)this.cropY, (double)this.cropZ, (double)((double)this.cropX + 1.0), (double)((double)this.cropY + 1.0), (double)((double)this.cropZ + 1.0));
    }
}

