/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.core.handler.configs.ConfigHandler;
import erebus.item.ItemMaterials;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityWisp
extends EntityMob {
    private ChunkCoordinates currentFlightTarget;
    private float heightOffset = 0.5f;
    public int lastX;
    public int lastY;
    public int lastZ;
    private float particleSpawnTick;
    public float particleSize;
    private boolean triggerOnce;

    public EntityWisp(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70728_aV = 2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)new Byte(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 5.0 : 5.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 1.0 : 1.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(8.0);
    }

    protected void func_70069_a(float distance) {
    }

    protected void func_70064_a(double distanceFallen, boolean onGround) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.particleSpawnTick += 1.0f;
        this.particleSize = this.particleSpawnTick <= 50.0f ? this.particleSpawnTick / 25.0f : 2.0f - (this.particleSpawnTick - 50.0f) / 25.0f;
        if (this.particleSpawnTick > 100.0f) {
            this.particleSpawnTick = 0.0f;
        }
        this.heightOffset = 1.5f + (float)this.field_70146_Z.nextGaussian() * 5.0f;
        if (this.func_70777_m() != null && this.func_70777_m().field_70163_u + (double)this.func_70777_m().func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
            double var1 = this.func_70777_m().field_70165_t + 0.5 - this.field_70165_t;
            double var3 = this.func_70777_m().field_70163_u + 1.0 - this.field_70163_u;
            double var5 = this.func_70777_m().field_70161_v + 0.5 - this.field_70161_v;
            this.field_70181_x += (0.350000011920929 - this.field_70181_x) * 0.350000011920929;
            this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(var3) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * (double)0.1f;
            float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
            this.field_70701_bs = 0.5f;
            this.field_70177_z += var8;
        }
        if (this.func_70777_m() == null) {
            this.flyAbout();
        }
    }

    protected void flyAbout() {
        if (!(this.currentFlightTarget == null || this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c) && this.currentFlightTarget.field_71572_b >= 1)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 4.0f) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.field_70163_u + this.field_70146_Z.nextInt(6) - 2, (int)this.field_70161_v + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
        }
        double var1 = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
        double var3 = (double)this.currentFlightTarget.field_71572_b + 0.1 - this.field_70163_u;
        double var5 = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(var1) * 0.5 - this.field_70159_w) * (double)0.1f;
        this.field_70181_x += (Math.signum(var3) * 0.8 - this.field_70181_x) * (double)0.1f;
        this.field_70179_y += (Math.signum(var5) * 0.5 - this.field_70179_y) * (double)0.1f;
        float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
        this.field_70701_bs = 0.5f;
        this.field_70177_z += var8;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.findNearEntity();
        }
        if (this.field_70170_p.field_72995_K && this.isGlowing()) {
            this.lightUp(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        }
        if (this.field_70170_p.field_72995_K && !this.isGlowing()) {
            this.switchOff();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u) - 1, MathHelper.func_76128_c((double)this.field_70161_v)) == Blocks.field_150355_j) {
            this.field_70181_x += 0.1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void lightUp(World world, int x, int y, int z) {
        if (!ConfigHandler.INSTANCE.bioluminescence) {
            return;
        }
        world.func_72915_b(EnumSkyBlock.Block, x, y, z, 9);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (x + i == this.lastX && y + j == this.lastY && z + k == this.lastZ && !this.field_70128_L) continue;
                    world.func_147463_c(EnumSkyBlock.Block, this.lastX + i, this.lastY + j, this.lastZ + k);
                    this.lastX = x;
                    this.lastY = y;
                    this.lastZ = z;
                }
            }
        }
        this.triggerOnce = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void switchOff() {
        if (!ConfigHandler.INSTANCE.bioluminescence) {
            return;
        }
        if (this.triggerOnce) {
            this.field_70170_p.func_147463_c(EnumSkyBlock.Block, this.lastX, this.lastY, this.lastZ);
            this.field_70170_p.func_147463_c(EnumSkyBlock.Block, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            this.triggerOnce = false;
        }
    }

    protected Entity findNearEntity() {
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 0.5), (double)(this.field_70163_u - 0.5), (double)(this.field_70161_v - 0.5), (double)(this.field_70165_t + 0.5), (double)(this.field_70163_u + 0.5), (double)(this.field_70161_v + 0.5)).func_72314_b(16.0, 16.0, 16.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || this.getIsNearEntity()) continue;
            this.setIsNearEntity(true);
        }
        if (list.isEmpty() && this.getIsNearEntity()) {
            this.setIsNearEntity(false);
        }
        return null;
    }

    public boolean isGlowing() {
        return this.field_70170_p.func_72971_b(1.0f) < 0.5f && this.getIsNearEntity();
    }

    public void setIsNearEntity(boolean entityNear) {
        this.field_70180_af.func_75692_b(30, (Object)(entityNear ? (byte)1 : 0));
    }

    public boolean getIsNearEntity() {
        return this.field_70180_af.func_75683_a(30) == 1;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.switchOff();
        }
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(ItemMaterials.DATA.BIO_LUMINESCENCE.makeStack(), 0.0f);
        }
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty();
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.field_73013_u.ordinal() > EnumDifficulty.EASY.ordinal() && this.field_70146_Z.nextInt(19) == 0) {
                    if (this.field_70170_p.field_73013_u == EnumDifficulty.NORMAL) {
                        duration = 5;
                    } else if (this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                        duration = 10;
                    }
                }
                if (duration > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected void func_70785_a(Entity entity, float distance) {
        if (distance < 2.0f) {
            super.func_70785_a(entity, distance);
            this.func_70652_k(entity);
        }
    }
}

