/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.Erebus;
import erebus.client.render.entity.AnimationMathHelper;
import erebus.core.handler.configs.ConfigHandler;
import erebus.item.ItemMaterials;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityDragonfly
extends EntityMob {
    private ChunkCoordinates currentFlightTarget;
    EntityLivingBase field_70789_a;
    AnimationMathHelper mathWings = new AnimationMathHelper();
    public float wingFloat;
    public double pickupHeight;
    private boolean dropped;
    private int droptime = 0;
    private int countDown;

    public EntityDragonfly(World world) {
        super(world);
        this.func_70105_a(2.5f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(30, (Object)new Integer(this.field_70146_Z.nextInt(51)));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 1.0 : 1.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected boolean func_70650_aV() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean captured() {
        return this.field_70153_n != null;
    }

    private void setCountdown(int count) {
        this.countDown = count;
    }

    private void setDropped(boolean dropstate) {
        this.dropped = dropstate;
    }

    public boolean getDropped() {
        return this.dropped;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    protected String func_70639_aQ() {
        return this.field_70146_Z.nextInt(4) != 0 ? null : "erebus:flysound";
    }

    protected String func_70621_aR() {
        return "erebus:flyhurt";
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.wingFloat = this.mathWings.swing(4.0f, 0.1f);
        this.field_70181_x *= (double)0.6f;
        if (this.func_70777_m() == null) {
            this.flyAbout();
        }
        if (this.field_70153_n != null && !this.field_70170_p.field_72995_K && this.captured() && (this.field_70163_u > this.pickupHeight + 10.0 || this.countDown <= 0 || !this.field_70170_p.field_72995_K && this.captured() && this.field_70170_p.isSideSolid(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v), ForgeDirection.UP))) {
            this.setDropped(true);
            this.field_70153_n.func_70078_a(null);
        }
        if (this.dropped) {
            ++this.droptime;
            if (this.droptime >= 20) {
                this.setDropped(false);
                this.droptime = 0;
            }
        }
        if (this.countDown >= 0) {
            --this.countDown;
        }
        if (this.func_70777_m() != null) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.func_70777_m().field_70165_t, (int)((float)((int)this.func_70777_m().field_70163_u) + this.func_70777_m().func_70047_e()), (int)this.func_70777_m().field_70161_v);
            this.flyToTarget();
        }
        if (this.field_70170_p.field_72995_K && this.getSkin() == 0) {
            this.spawnParticles(this.field_70170_p, this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70146_Z);
            if (!this.func_94056_bM()) {
                this.func_94058_c("Ender Dragonfly");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 20; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextInt(2) * 2 - 1;
            int motionZ = rand.nextInt(2) * 2 - 1;
            velY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velZ = rand.nextFloat() * 1.0f * (float)motionZ;
            velX = rand.nextFloat() * 1.0f * (float)motionX;
            Erebus.proxy.spawnCustomParticle("portal", this.field_70170_p, x, y, z, velX, velY, velZ);
        }
    }

    public void flyAbout() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.field_70759_as = this.field_70146_Z.nextInt(360);
        }
        if (this.currentFlightTarget != null && !this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b, this.currentFlightTarget.field_71573_c) && (this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b - 3, this.currentFlightTarget.field_71573_c) || this.currentFlightTarget.field_71572_b < 1)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.field_70146_Z.nextInt(30) == 0 || this.currentFlightTarget.func_71569_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 4.0f) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.field_70165_t + this.field_70146_Z.nextInt(10) - this.field_70146_Z.nextInt(10), (int)this.field_70163_u + this.field_70146_Z.nextInt(4) - this.field_70146_Z.nextInt(4), (int)this.field_70161_v + this.field_70146_Z.nextInt(10) - this.field_70146_Z.nextInt(10));
        }
        if (this.currentFlightTarget != null && this.func_70777_m() != null && !this.field_70170_p.func_147437_c(this.currentFlightTarget.field_71574_a, this.currentFlightTarget.field_71572_b - 3, this.currentFlightTarget.field_71573_c) || this.currentFlightTarget != null && !this.getDropped() && (double)this.currentFlightTarget.field_71572_b < this.pickupHeight + 10.0) {
            ++this.currentFlightTarget.field_71572_b;
        }
        this.flyToTarget();
    }

    public void flyToTarget() {
        double targetX = (double)this.currentFlightTarget.field_71574_a + 0.5 - this.field_70165_t;
        double targetY = (double)this.currentFlightTarget.field_71572_b + 1.0 - this.field_70163_u;
        double targetZ = (double)this.currentFlightTarget.field_71573_c + 0.5 - this.field_70161_v;
        this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.20000000149011612;
        this.field_70181_x += (Math.signum(targetY) * (double)0.7f - this.field_70181_x) * 0.30000000149011613;
        this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.20000000149011612;
        float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
        float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
        this.field_70701_bs = 0.5f;
        this.field_70177_z += rotation;
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        if (player.func_70093_af()) {
            player.func_70095_a(false);
        }
        if (!(this.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d || this.captured() || this.field_70146_Z.nextInt(20) != 0 || this.getDropped())) {
            player.func_70078_a((Entity)this);
            this.pickupHeight = this.field_70163_u;
            this.setCountdown(60);
        }
    }

    public void func_70043_V() {
        super.func_70043_V();
        if (this.field_70153_n instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * -0.6;
            double offSetZ = Math.cos(a) * -0.6;
            this.field_70153_n.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u, this.field_70161_v - offSetZ);
        }
    }

    protected Entity func_70782_k() {
        return this.field_70170_p.func_72856_b((Entity)this, 16.0);
    }

    public boolean func_70097_a(DamageSource source, float amp) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (super.func_70097_a(source, amp)) {
            Entity entity = source.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.field_70789_a = (EntityLivingBase)entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70601_bi() {
        int var5;
        int var3;
        int var1 = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        if (var1 >= 100) {
            return false;
        }
        int var2 = MathHelper.func_76128_c((double)this.field_70165_t);
        int var4 = this.field_70170_p.func_72957_l(var2, var1, var3 = MathHelper.func_76128_c((double)this.field_70161_v));
        return var4 > this.field_70146_Z.nextInt(var5 = 7) ? false : super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 6;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(ItemMaterials.DATA.DRAGONFLY_WING.makeStack(), 0.0f);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(ItemMaterials.DATA.COMPOUND_EYES.makeStack(this.field_70146_Z.nextInt(1) + 1 + looting), 0.0f);
        }
        if (this.getSkin() == 0) {
            this.func_70099_a(new ItemStack(Items.field_151079_bi, this.field_70146_Z.nextInt(1) + 1 + looting), 0.0f);
        }
    }

    public boolean func_70652_k(Entity entity) {
        return super.func_70652_k(entity);
    }

    protected void func_70785_a(Entity entity, float distance) {
        if (distance < 2.0f && entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            super.func_70785_a(entity, distance);
        }
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_75692_b(30, (Object)new Integer(skinType));
    }

    public int getSkin() {
        return this.field_70180_af.func_75679_c(30);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("dragonflySkin", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSkin(nbt.func_74762_e("dragonflySkin"));
    }
}

