/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityCrushling;
import erebus.entity.EntityPunchroom;
import erebus.entity.EntitySporeBall;
import erebus.entity.EntityZombieAnt;
import erebus.entity.EntityZombieAntSoldier;
import erebus.item.ItemMaterials;
import erebus.network.AbstractPacket;
import erebus.network.PacketPipeline;
import erebus.network.client.PacketParticle;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCrushroom
extends EntityMob
implements IRangedAttackMob,
IBossDisplayData {
    private final EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 0.75, 40, 12.0f);

    public EntityCrushroom(World world) {
        super(world);
        this.func_70105_a(3.3f, 4.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 200.0 : 200.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 6.0 : 6.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(22, (Object)new Byte(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70636_d() {
        this.field_70170_p.func_72869_a("reddust", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 1.0 + this.field_70146_Z.nextDouble(), 1.0 + this.field_70146_Z.nextDouble(), 1.0 + this.field_70146_Z.nextDouble());
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 20.0f);
            double distance = this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().field_70121_D.field_72338_b, this.func_70638_az().field_70161_v);
            if (distance > 5.0 && distance <= 12.0) {
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiArrowAttack);
                if (this.getSmashCount() >= 1) {
                    this.setSmashCount(this.getSmashCount() - 1);
                    this.setStanding((byte)3);
                    if (this.getSmashCount() == 0) {
                        this.setStanding((byte)0);
                    }
                }
            }
            if (distance <= 5.0) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
                if (this.getSmashCount() < 20 && this.getStanding() != 3) {
                    this.setSmashCount(this.getSmashCount() + 1);
                    this.setStanding((byte)2);
                }
                if (this.getSmashCount() >= 20 && this.getStanding() == 2) {
                    this.setStanding((byte)3);
                    this.meleeAttackPlayer();
                }
                if (this.getSmashCount() >= 1 && this.getStanding() == 3) {
                    this.setSmashCount(this.getSmashCount() - 1);
                    if (this.getSmashCount() == 0) {
                        this.setStanding((byte)2);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null) {
            this.setStanding((byte)1);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiArrowAttack);
        }
        super.func_70636_d();
    }

    private void setStanding(byte state) {
        this.field_70180_af.func_75692_b(22, (Object)state);
    }

    public byte getStanding() {
        return this.field_70180_af.func_75683_a(22);
    }

    private void setSmashCount(int count) {
        this.field_70180_af.func_75692_b(21, (Object)count);
    }

    public int getSmashCount() {
        return this.field_70180_af.func_75679_c(21);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c(1.0f);
        if (light >= 0.0f) {
            return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    protected String func_70639_aQ() {
        return "erebus:sporelingliving";
    }

    protected String func_70621_aR() {
        return "erebus:sporelinghurt";
    }

    protected String func_70673_aS() {
        return "erebus:sporelingdeath";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.irongolem.walk", 1.0f, 0.5f);
    }

    protected float func_70647_i() {
        return 0.1f;
    }

    protected void func_70628_a(boolean recentHit, int fortune) {
        int amount = this.field_70146_Z.nextInt(3);
        if (fortune > 0) {
            amount += this.field_70146_Z.nextInt(fortune + 1);
        }
        this.func_70099_a(ItemMaterials.DATA.HIDE_SHROOM.makeStack(amount), 0.0f);
    }

    public boolean func_70686_a(Class entity) {
        return EntityCrushroom.class != entity && EntityCrushling.class != entity && EntityZombieAnt.class != entity && EntityZombieAntSoldier.class != entity && EntityPunchroom.class != entity;
    }

    public void func_82196_d(EntityLivingBase entity, float range) {
        EntitySporeBall sporeball = new EntitySporeBall(this.field_70170_p, (EntityLiving)this);
        double distanceX = entity.field_70165_t - this.field_70165_t;
        double distanceY = entity.field_70163_u + (double)this.field_70131_O - 4.0 - sporeball.field_70163_u;
        double distanceZ = entity.field_70161_v - this.field_70161_v;
        float height = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ)) * 0.2f;
        sporeball.func_70186_c(distanceX, distanceY + (double)height, distanceZ, 1.6f, 12.0f);
        this.func_85030_a("erebus:spraycansound", 0.5f, 0.1f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)sporeball);
    }

    private void meleeAttackPlayer() {
        if (!this.field_70170_p.field_72995_K && this.func_70638_az().field_70121_D.field_72337_e >= this.field_70121_D.field_72338_b - 1.0 && this.func_70638_az().field_70121_D.field_72338_b <= this.field_70121_D.field_72337_e && this.getSmashCount() == 20) {
            this.func_85030_a("erebus:blamsound", 0.5f, 1.0f);
            this.spawnBlamParticles();
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 6.0 : 6.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            this.func_70638_az().func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f))) * 0.5, 0.2, (double)MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * 0.5);
        }
    }

    public void spawnBlamParticles() {
        PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new PacketParticle((Entity)this, PacketParticle.ParticleType.CRUSHROOM_BLAM));
    }
}

