/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.core.proxy.CommonProxy;
import erebus.entity.ai.EntityAIAntBonemealCrops;
import erebus.entity.ai.EntityAIAntHarvestCrops;
import erebus.entity.ai.EntityAIAntPlantCrops;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityBlackAnt
extends EntityTameable
implements IInventory {
    private final EntityAIPanic aiPanic = new EntityAIPanic((EntityCreature)this, 0.8);
    private final EntityAIAntHarvestCrops aiHarvestCrops = new EntityAIAntHarvestCrops((EntityLivingBase)this, 0.6, 1);
    private final EntityAIAntPlantCrops aiPlantCrops = new EntityAIAntPlantCrops((EntityLivingBase)this, 0.6, 4);
    private final EntityAIAntBonemealCrops aiBonemealCrops = new EntityAIAntBonemealCrops((EntityLivingBase)this, 0.6, 4);
    private final EntityAIWander aiWander = new EntityAIWander((EntityCreature)this, 0.6);
    public boolean setAttributes;
    public boolean canPickupItems;
    public boolean canCollectFromSilo;
    public boolean canAddToSilo;
    protected ItemStack[] inventory;
    public static final int TOOL_SLOT = 0;
    public static final int CROP_ID_SLOT = 1;
    public static final int INVENTORY_SLOT = 2;
    private static final String[] names = new String[]{"Antwan", "George", "Geoff", "Alberto", "Jose", "Linda", "Chantelle", "Dave", "Basil", "Gertrude", "Herbert", "Russel", "Adam", "Gwen", "Billy Bob Joe Bob Joe Harrison Jr.", "Sid", "Dylan", "Jade"};

    public EntityBlackAnt(World world) {
        super(world);
        this.field_70138_W = 1.0f;
        this.setAttributes = false;
        this.canPickupItems = false;
        this.canAddToSilo = false;
        this.canCollectFromSilo = false;
        this.func_70105_a(0.9f, 0.4f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWander);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiPanic);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.6, ModItems.antTamingAmulet, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.6, Items.field_151102_aT, false));
        this.inventory = new ItemStack[3];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(24, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(25, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(26, (Object)new Integer(0));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected String func_70639_aQ() {
        return "erebus:fireantsound";
    }

    protected String func_70621_aR() {
        return "erebus:fireanthurt";
    }

    protected String func_70673_aS() {
        return "erebus:squish";
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.spider.step", 0.15f, 1.0f);
    }

    public int func_70641_bl() {
        return 5;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c(1.0f);
        if (light >= 0.0f) {
            return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
        }
        return super.func_70601_bi();
    }

    public boolean func_70909_n() {
        return this.field_70180_af.func_75683_a(16) != 0;
    }

    public void func_70903_f(boolean tamed) {
        if (tamed) {
            this.field_70180_af.func_75692_b(16, (Object)1);
            if (!this.func_94056_bM()) {
                this.func_94058_c(names[this.field_70170_p.field_73012_v.nextInt(names.length)]);
            }
        } else {
            this.field_70180_af.func_75692_b(16, (Object)0);
        }
    }

    public void openGUI(EntityPlayer player) {
        player.openGui((Object)Erebus.instance, CommonProxy.GuiID.ANT_INVENTORY.ordinal(), player.field_70170_p, this.func_145782_y(), 0, 0);
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is != null && is.func_77973_b() == ModItems.antTamingAmulet && is.func_77942_o() && is.field_77990_d.func_74764_b("homeX")) {
            this.setDropPoint(is.func_77978_p().func_74762_e("homeX"), is.func_77978_p().func_74762_e("homeY"), is.func_77978_p().func_74762_e("homeZ"));
            player.func_71038_i();
            this.func_70903_f(true);
            this.func_70908_e(true);
            return true;
        }
        if (this.func_70909_n()) {
            this.func_70295_k_();
            this.openGUI(player);
        }
        return super.func_70085_c(player);
    }

    public void setBlockHarvested(Block block, int meta) {
        Random rand = new Random();
        if (block != null) {
            Utils.dropStack(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, new ItemStack(block.func_149650_a(meta, rand, 0), rand.nextInt(2) + 1));
            Utils.dropStack(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, new ItemStack(block.func_149650_a(0, rand, 0), rand.nextInt(2) + 1));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.setAttributes) {
            if (this.func_70909_n()) {
                this.func_70295_k_();
                this.func_70305_f();
            }
            this.setAttributes = true;
        }
    }

    protected void func_82160_b(boolean rencentHit, int fortune) {
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }

    private void addToInventory(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = stack.func_77946_l();
            stack.field_77994_a = 0;
        } else if (Utils.areStacksTheSame(stack, this.inventory[2], false)) {
            int old = this.inventory[2].field_77994_a;
            this.inventory[2].field_77994_a += stack.field_77994_a;
            if (this.inventory[2].field_77994_a > this.inventory[2].func_77976_d()) {
                this.inventory[2].field_77994_a = this.inventory[2].func_77976_d();
            }
            int added = this.inventory[2].field_77994_a - old;
            stack.field_77994_a -= added;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70909_n()) {
            Block block;
            EntityItem entityitem;
            if (this.canPickupItems && !this.isFilterSlotEmpty() && (this.getAntInvSlotStack() == null || this.getAntInvSlotStack().field_77994_a < this.getAntInvSlotStack().func_77976_d()) && (entityitem = this.getClosestEntityItem((Entity)this, 16.0, this.getFilterSlotStack())) != null) {
                float distance = entityitem.func_70032_d((Entity)this);
                if (distance >= 2.0f && entityitem.field_145804_b <= 0 && !entityitem.field_70128_L) {
                    double x = entityitem.field_70165_t;
                    double y = entityitem.field_70163_u;
                    double z = entityitem.field_70161_v;
                    this.func_70671_ap().func_75650_a(x, y, z, 20.0f, 8.0f);
                    this.moveToItem((Entity)entityitem);
                    return;
                }
                if (distance < 2.0f) {
                    this.func_70605_aq().func_75642_a(entityitem.field_70165_t, entityitem.field_70163_u, entityitem.field_70161_v, 0.5);
                    this.addToInventory(entityitem.func_92059_d());
                    if (entityitem.func_92059_d().field_77994_a <= 0) {
                        entityitem.func_70106_y();
                    }
                    return;
                }
            }
            if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemBucket && !this.isAntInvSlotEmpty() && this.getAntInvSlotStack().field_77994_a > 15) {
                this.canAddToSilo = true;
                this.canPickupItems = false;
            }
            if (!this.canPickupItems && this.canAddToSilo) {
                this.moveToSilo();
                block = this.field_70170_p.func_147439_a(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
                if (block == ModBlocks.siloTank && this.func_70011_f((double)this.getDropPointX() + 0.5, (double)this.getDropPointY() - 1.0, (double)this.getDropPointZ() + 0.5) < 2.0) {
                    this.addDropToInventory(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
                    this.canAddToSilo = false;
                    this.canPickupItems = true;
                }
            }
            if ((!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemHoe || !this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() == Items.field_151103_aS) && this.isAntInvSlotEmpty() && !this.isFilterSlotEmpty()) {
                this.canCollectFromSilo = true;
            }
            if (this.canCollectFromSilo) {
                this.moveToSilo();
                block = this.field_70170_p.func_147439_a(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
                if (block == ModBlocks.siloTank && this.func_70011_f((double)this.getDropPointX() + 0.5, (double)this.getDropPointY() - 1.0, (double)this.getDropPointZ() + 0.5) < 2.0) {
                    this.getStackFromSilo();
                    this.canCollectFromSilo = false;
                }
            }
        }
    }

    private void getStackFromSilo() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        IInventory siloTile = (IInventory)this.field_70170_p.func_147438_o(this.getDropPointX(), this.getDropPointY(), this.getDropPointZ());
        ItemStack[] siloInventory = new ItemStack[siloTile.func_70302_i_()];
        for (int i = 0; i < siloInventory.length; ++i) {
            if (siloTile.func_70301_a(i) == null || siloTile.func_70301_a(i).func_77973_b() != this.func_70301_a(1).func_77973_b() || siloTile.func_70301_a(i).func_77960_j() != this.func_70301_a(1).func_77960_j() || !this.isAntInvSlotEmpty()) continue;
            int collectStackSize = siloTile.func_70301_a((int)i).field_77994_a;
            this.func_70299_a(2, new ItemStack(siloTile.func_70301_a(i).func_77973_b(), collectStackSize, siloTile.func_70301_a(i).func_77960_j()));
            siloTile.func_70298_a(i, collectStackSize);
            return;
        }
    }

    private void addDropToInventory(int x, int y, int z) {
        ItemStack stack = this.getAntInvSlotStack();
        if (!this.isAntInvSlotEmpty()) {
            Utils.addItemStackToInventory(Utils.getTileEntity((IBlockAccess)this.field_70170_p, x, y, z, IInventory.class), new ItemStack(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j()));
        }
        this.func_70299_a(2, null);
    }

    public EntityItem getClosestEntityItem(final Entity entity, double d, ItemStack filter) {
        List list = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(d, d, d));
        if (list.isEmpty()) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityItem item = (EntityItem)iterator.next();
            if (Utils.areStacksTheSame(filter, item.func_92059_d(), false) && item.field_145804_b <= 0) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, new Comparator<EntityItem>(){

            @Override
            public int compare(EntityItem e1, EntityItem e2) {
                return Double.compare(e1.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v), e2.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
            }
        });
        return (EntityItem)list.get(0);
    }

    public void moveToItem(Entity entity) {
        PathEntity pathentity = this.field_70170_p.func_72865_a((Entity)this, entity, 16.0f, true, false, false, true);
        if (pathentity != null) {
            this.func_70778_a(pathentity);
            this.func_70661_as().func_75484_a(pathentity, 0.5);
        }
    }

    public void moveToSilo() {
        PathEntity pathentity = this.field_70170_p.func_72844_a((Entity)this, this.getDropPointX(), this.getDropPointY() - 1, this.getDropPointZ(), 16.0f, true, false, false, true);
        if (pathentity != null) {
            this.func_70778_a(pathentity);
            this.func_70661_as().func_75484_a(pathentity, 0.5);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= size) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(size);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "container.antInventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public final boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() == Items.field_151097_aZ || stack.func_77973_b() == Items.field_151133_ar || stack.func_77973_b() instanceof ItemHoe || stack.func_77973_b() == Items.field_151103_aS;
        }
        return true;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74771_c("tamed") == 1) {
            this.func_70903_f(true);
        } else {
            this.func_70903_f(false);
        }
        this.setDropPoint(nbt.func_74762_e("dropPointX"), nbt.func_74762_e("dropPointY"), nbt.func_74762_e("dropPointZ"));
        NBTTagList tags = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data = tags.func_150305_b(i);
            int j = data.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.func_70909_n()) {
            nbt.func_74774_a("tamed", Byte.valueOf((byte)1).byteValue());
        } else {
            nbt.func_74774_a("tamed", Byte.valueOf((byte)0).byteValue());
        }
        nbt.func_74768_a("dropPointX", this.getDropPointX());
        nbt.func_74768_a("dropPointY", this.getDropPointY());
        nbt.func_74768_a("dropPointZ", this.getDropPointZ());
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)tags);
    }

    public void func_70295_k_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.canPickupItems = false;
        this.canAddToSilo = false;
        this.canCollectFromSilo = false;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiPlantCrops);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiHarvestCrops);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiBonemealCrops);
    }

    public void func_70305_f() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isTaskSlotEmpty() && this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiWander);
            this.field_70180_af.func_75692_b(16, (Object)1);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemHoe && !this.isFilterSlotEmpty()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiPlantCrops);
            this.field_70180_af.func_75692_b(16, (Object)2);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemBucket && !this.isFilterSlotEmpty()) {
            this.canPickupItems = true;
            this.field_70180_af.func_75692_b(16, (Object)3);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() instanceof ItemShears) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiHarvestCrops);
            this.field_70180_af.func_75692_b(16, (Object)4);
        }
        if (!this.isTaskSlotEmpty() && this.getTaskSlotStack().func_77973_b() == Items.field_151103_aS && !this.isFilterSlotEmpty()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiBonemealCrops);
            this.field_70180_af.func_75692_b(16, (Object)5);
        }
        this.func_70619_bc();
    }

    public boolean isTaskSlotEmpty() {
        return this.getTaskSlotStack() == null;
    }

    public ItemStack getTaskSlotStack() {
        return this.func_70301_a(0);
    }

    public boolean isFilterSlotEmpty() {
        return this.getFilterSlotStack() == null;
    }

    public ItemStack getFilterSlotStack() {
        return this.func_70301_a(1);
    }

    public boolean isAntInvSlotEmpty() {
        return this.getAntInvSlotStack() == null;
    }

    public ItemStack getAntInvSlotStack() {
        return this.func_70301_a(2);
    }

    public void func_70296_d() {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public void setDropPoint(int x, int y, int z) {
        this.field_70180_af.func_75692_b(24, (Object)x);
        this.field_70180_af.func_75692_b(25, (Object)y);
        this.field_70180_af.func_75692_b(26, (Object)z);
    }

    public int getDropPointX() {
        return this.field_70180_af.func_75679_c(24);
    }

    public int getDropPointY() {
        return this.field_70180_af.func_75679_c(25);
    }

    public int getDropPointZ() {
        return this.field_70180_af.func_75679_c(26);
    }

    public EntityAgeable func_90011_a(EntityAgeable baby) {
        return null;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }
}

