/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.core.proxy.CommonProxy;
import erebus.entity.EntityMobBlock;
import erebus.entity.ai.EntityAIBlockFollowOwner;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityAnimatedBlock
extends EntityMobBlock
implements IEntityAdditionalSpawnData {
    public Block blockID;
    public int blockMeta;
    private int lastX = 0;
    private int lastY = 0;
    private int lastZ = 0;
    protected final EntityAIWander aiWander = new EntityAIWander((EntityCreature)this, 0.5);
    protected final EntityAINearestAttackableTarget aiAttackNearestTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true);
    protected final EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityMob.class, 0.5, false);

    public EntityAnimatedBlock(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.5f);
        this.setBlock(Blocks.field_150348_b, 0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiWander);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiAttackNearestTarget);
        this.field_70728_aV = 0;
    }

    public void setBlock(Block blockID, int blockMeta) {
        this.blockID = blockID;
        this.blockMeta = blockMeta;
        this.setCanBeTempted();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(18, (Object)"");
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 10.0 : 10.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.field_70170_p.func_72956_a((Entity)this, "mob.zombie.step", 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70128_L) {
            Utils.dropStack(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, new ItemStack(this.blockID, 1, this.blockMeta));
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72971_b(1.0f) < 0.5f) {
                this.lightUp(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            } else {
                this.switchOff();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void lightUp(World world, int x, int y, int z) {
        world.func_72915_b(EnumSkyBlock.Block, x, y, z, this.blockID.func_149750_m());
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (x + i == this.lastX && y + j == this.lastY && z + k == this.lastZ && !this.field_70128_L) continue;
                    world.func_147463_c(EnumSkyBlock.Block, this.lastX + i, this.lastY + j, this.lastZ + k);
                    this.lastX = x;
                    this.lastY = y;
                    this.lastZ = z;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void switchOff() {
        this.field_70170_p.func_147463_c(EnumSkyBlock.Block, this.lastX, this.lastY, this.lastZ);
        this.field_70170_p.func_147463_c(EnumSkyBlock.Block, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            this.switchOff();
        }
    }

    public boolean isClimbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!this.field_70170_p.field_72995_K && is != null && is.func_77973_b() == ModItems.wandOfAnimation) {
            this.func_70106_y();
            this.field_70170_p.func_147465_d(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), this.blockID, this.blockMeta, 3);
            this.field_70170_p.func_72908_a((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.field_70163_u), (double)MathHelper.func_76128_c((double)this.field_70161_v), "erebus:altaroffering", 0.2f, 1.0f);
            return true;
        }
        if (this.blockID == ModBlocks.petrifiedCraftingTable && is == null) {
            player.openGui((Object)Erebus.instance, CommonProxy.GuiID.PETRIFIED_CRAFT.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return true;
        }
        return false;
    }

    @Override
    protected void func_70785_a(Entity entity, float distance) {
        if (distance > 0.0f && distance < 2.0f) {
            this.func_70652_k(entity);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean atk = false;
        if (super.func_70652_k(entity)) {
            atk = entity instanceof EntityMob;
        }
        return atk;
    }

    public void setCanBeTempted() {
        if (this.blockID == ModBlocks.petrifiedCraftingTable) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBlockFollowOwner(this, 1.0, 10.0f, 2.0f));
        }
    }

    public void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        data.func_74768_a("blockID", Block.func_149682_b((Block)this.blockID));
        data.func_74768_a("blockMeta", this.blockMeta);
        if (this.getOwnerName() == null) {
            data.func_74778_a("OwnerUUID", "");
        } else {
            data.func_74778_a("OwnerUUID", this.getOwnerName());
        }
    }

    public void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.blockID = Block.func_149729_e((int)data.func_74762_e("blockID"));
        this.blockMeta = data.func_74762_e("blockMeta");
        this.setCanBeTempted();
        String s = "";
        if (data.func_150297_b("OwnerUUID", 8)) {
            s = data.func_74779_i("OwnerUUID");
        } else {
            String s1 = data.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_152719_a((String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerName(s);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Block.func_149682_b((Block)this.blockID));
        buffer.writeInt(this.blockMeta);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.blockID = Block.func_149729_e((int)buffer.readInt());
        this.blockMeta = buffer.readInt();
        this.setCanBeTempted();
    }

    public String getOwnerName() {
        return this.field_70180_af.func_75681_e(18);
    }

    public void setOwnerName(String name) {
        this.field_70180_af.func_75692_b(18, (Object)name);
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = UUID.fromString(this.getOwnerName());
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean belongsTo(EntityLivingBase entity) {
        return entity == this.getOwner();
    }
}

