/*
 * Decompiled with CFR 0.152.
 */
package erebus.debug;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.gen.feature.WorldGenerator;

public class ErebusCommandDebug
extends CommandBase {
    private static final IChatComponent text(String str, Object ... objects) {
        return new ChatComponentTranslation(str, objects);
    }

    public String func_71517_b() {
        return "erebus";
    }

    public int func_82362_a() {
        return 3;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.erebus.debug.usage";
    }

    public void func_71515_b(ICommandSender sender, String[] params) {
        block16: {
            if (!(sender instanceof EntityPlayer)) {
                sender.func_145747_a(ErebusCommandDebug.text("command.erebus.commanddenied", new Object[0]));
                return;
            }
            EntityPlayer player = (EntityPlayer)sender;
            if (params.length == 0) {
                sender.func_145747_a(ErebusCommandDebug.text("command.erebus.available", new Object[0]));
                sender.func_145747_a(ErebusCommandDebug.text("command.erebus.gen", new Object[0]));
                sender.func_145747_a(ErebusCommandDebug.text("/erebus debug", new Object[0]));
            } else if (params[0].equals("gen") && params.length >= 3) {
                try {
                    Class<?> cls = Class.forName("erebus.world.feature." + params[1] + ".WorldGen" + params[2]);
                    WorldGenerator gen = (WorldGenerator)cls.newInstance();
                    ChunkCoordinates coords = sender.func_82114_b();
                    if (gen.func_76484_a(sender.func_130014_f_(), sender.func_130014_f_().field_73012_v, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) {
                        sender.func_145747_a(ErebusCommandDebug.text("command.erebus.generated", new Object[0]));
                        break block16;
                    }
                    sender.func_145747_a(ErebusCommandDebug.text("command.erebus.failed", new Object[0]));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    sender.func_145747_a(ErebusCommandDebug.text("command.erebus.somethingwentwrong", new Object[0]));
                }
            } else if (params[0].equals("debug")) {
                String response = "";
                int creature = player.field_70170_p.countEntities(EnumCreatureType.creature, true);
                int monster = player.field_70170_p.countEntities(EnumCreatureType.monster, true);
                int ambient = player.field_70170_p.countEntities(EnumCreatureType.ambient, true);
                response = "Mob count: creature " + creature + ", monster " + monster + ", ambient " + ambient;
                List list = player.field_70170_p.field_72996_f;
                HashMap<EnumCreatureType, HashSet<String>> mobs = new HashMap<EnumCreatureType, HashSet<String>>();
                for (Entity entity : list) {
                    for (EnumCreatureType type : EnumCreatureType.values()) {
                        if (!entity.isCreatureType(type, true)) continue;
                        HashSet<String> set = (HashSet<String>)mobs.get(type);
                        if (set == null) {
                            set = new HashSet<String>();
                            mobs.put(type, set);
                        }
                        set.add(entity.getClass().getSimpleName());
                    }
                }
                for (Map.Entry entry : mobs.entrySet()) {
                    StringBuilder build = new StringBuilder();
                    build.append("\n").append(((EnumCreatureType)entry.getKey()).name()).append(" - ");
                    for (String s : (Set)entry.getValue()) {
                        build.append(s).append(", ");
                    }
                    build.delete(build.length() - 2, build.length());
                    response = response + build.toString();
                }
                for (Iterator<Object> iterator : response.split("\n")) {
                    sender.func_145747_a(ErebusCommandDebug.text(iterator, new Object[0]));
                }
            } else {
                sender.func_145747_a(ErebusCommandDebug.text("Wrong command u noob.", new Object[0]));
            }
        }
    }
}

