/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.helper;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    private static final String[] orePrefixes = new String[]{"dust", "ingot", "ore", "block", "gem", "nugget", "shard", "plate", "gear", "stickWood"};

    public static void sendUpdatesToClient(World world, Packet descriptionPacket) {
        List players = world.field_73010_i;
        for (EntityPlayerMP player : players) {
            player.field_71135_a.func_147359_a(descriptionPacket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rightClickItemAt(World world, int x, int y, int z, int side, ItemStack stack) {
        if (world.field_72995_K || stack == null || stack.func_77973_b() == null) {
            return false;
        }
        EntityPlayer player = Utils.getPlayer(world);
        player.func_70062_b(0, stack);
        try {
            boolean bl = stack.func_77973_b().func_77648_a(stack, player, world, x, y, z, side, 0.0f, 0.0f, 0.0f);
            return bl;
        }
        finally {
            player.func_70062_b(0, null);
        }
    }

    public static EntityPlayer getPlayer(World world) {
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return null;
        }
        return FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("erebus".getBytes()), "[erebus]"));
    }

    public static final int getFlowerMetadata(Object obj) {
        int meta = -1;
        if (obj instanceof ItemStack) {
            meta = ((ItemStack)obj).func_77960_j();
        } else if (obj instanceof Integer) {
            meta = (Integer)obj;
        }
        if (meta >= 2 && meta <= 8 || meta == 14) {
            ++meta;
        } else if (meta >= 9 && meta <= 13) {
            meta += 2;
        }
        return meta;
    }

    public static final void breakBlockWithParticles(World world, int x, int y, int z, int meta) {
        Utils.playBreakParticles(world, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public static final void breakBlockWithParticles(World world, int x, int y, int z) {
        Utils.breakBlockWithParticles(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public static void playBreakParticles(World world, int x, int y, int z, int meta) {
        world.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)world.func_147439_a(x, y, z)) + (meta << 12));
    }

    public static void playBreakParticles(World world, int x, int y, int z) {
        world.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)world.func_147439_a(x, y, z)) + (world.func_72805_g(x, y, z) << 12));
    }

    public static final void dropStack(World world, int x, int y, int z, ItemStack is) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, is);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static final int getColour(int R, int G, int B) {
        return new Color(R, G, B).getRGB() & 0xFFFFFF;
    }

    public static final <T> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<T> cls) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!cls.isInstance(tile)) {
            return null;
        }
        return (T)tile;
    }

    public static void dropStackNoRandom(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && stack != null && world.func_82736_K().func_82766_b("doTileDrops")) {
            EntityItem entityItem = new EntityItem(world, (double)x + 0.5, (double)y, (double)z + 0.5, stack);
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            entityItem.field_145804_b = 10;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static int[] getSlotsFromSide(IInventory iinventory, int side) {
        if (iinventory == null) {
            return null;
        }
        if (iinventory instanceof ISidedInventory) {
            return ((ISidedInventory)iinventory).func_94128_d(side);
        }
        int[] slots = new int[iinventory.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static ItemStack extractFromInventory(IInventory iinventory, int side) {
        return Utils.extractFromInventory(iinventory, side, 1);
    }

    public static ItemStack extractFromInventory(IInventory iinventory, int side, int maxStackSize) {
        IInventory invt = Utils.getInventory(iinventory);
        return Utils.extractFromSlots(invt, side, maxStackSize, Utils.getSlotsFromSide(invt, side));
    }

    private static ItemStack extractFromSlots(IInventory iinventory, int side, int maxStackSize, int[] slots) {
        for (int slot : slots) {
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (invtStack == null || iinventory instanceof ISidedInventory && !((ISidedInventory)iinventory).func_102008_b(slot, invtStack, side)) continue;
            ItemStack copy = invtStack.func_77946_l();
            if (maxStackSize <= 0) {
                iinventory.func_70299_a(slot, null);
            } else {
                int amount = Math.min(maxStackSize, invtStack.field_77994_a);
                invtStack.field_77994_a -= amount;
                copy.field_77994_a = amount;
                if (invtStack.field_77994_a <= 0) {
                    iinventory.func_70299_a(slot, null);
                }
            }
            return copy;
        }
        return null;
    }

    public static boolean addEntitytoInventory(IInventory iinventory, EntityItem entity) {
        if (entity == null) {
            return false;
        }
        boolean flag = Utils.addItemStackToInventory(iinventory, entity.func_92059_d());
        if (flag) {
            entity.func_70106_y();
        } else if (entity.func_92059_d().field_77994_a <= 0) {
            entity.func_70106_y();
        }
        return flag;
    }

    public static boolean addItemStackToInventory(IInventory iinventory, ItemStack stack) {
        return Utils.addItemStackToInventory(iinventory, stack, 0);
    }

    public static boolean addItemStackToInventory(IInventory iinventory, ItemStack stack, int side) {
        if (iinventory == null) {
            return false;
        }
        if (stack == null || stack.field_77994_a <= 0) {
            return false;
        }
        IInventory invt = Utils.getInventory(iinventory);
        return Utils.addToSlots(invt, stack, side, Utils.getSlotsFromSide(invt, side));
    }

    private static boolean addToSlots(IInventory iinventory, ItemStack stack, int side, int[] slots) {
        for (int slot : slots) {
            if (!(iinventory instanceof ISidedInventory) ? !iinventory.func_94041_b(slot, stack) : !((ISidedInventory)iinventory).func_102007_a(slot, stack, side)) continue;
            if (iinventory.func_70301_a(slot) == null) {
                iinventory.func_70299_a(slot, stack.func_77946_l());
                stack.field_77994_a = 0;
                return true;
            }
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (invtStack.field_77994_a >= Math.min(invtStack.func_77976_d(), iinventory.func_70297_j_()) || !Utils.areStacksTheSame(invtStack, stack, false)) continue;
            invtStack.field_77994_a += stack.field_77994_a;
            if (invtStack.field_77994_a > invtStack.func_77976_d()) {
                stack.field_77994_a = invtStack.field_77994_a - invtStack.func_77976_d();
                invtStack.field_77994_a = invtStack.func_77976_d();
            } else {
                stack.field_77994_a = 0;
            }
            return true;
        }
        return false;
    }

    public static boolean areStacksSameOre(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (Utils.areStacksTheSame(stack1, stack2, false)) {
            return true;
        }
        List<String> ores1 = Utils.getOreNames(stack1);
        List<String> ores2 = Utils.getOreNames(stack2);
        if (ores1.isEmpty() || ores2.isEmpty()) {
            return false;
        }
        for (String ore2 : ores2) {
            if (!ores1.contains(ore2)) continue;
            return Utils.isIntercheageableOreName(ore2);
        }
        return false;
    }

    private static boolean isIntercheageableOreName(String name) {
        for (String prefix : orePrefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static boolean isItemOre(ItemStack stack, String ore) {
        int oreID = OreDictionary.getOreID((String)ore);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id != oreID) continue;
            return true;
        }
        return false;
    }

    public static boolean areStacksTheSame(ItemStack stack1, ItemStack stack2, boolean matchSize) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!(stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77960_j() != stack2.func_77960_j() && !Utils.isWildcard(stack1.func_77960_j()) && !Utils.isWildcard(stack2.func_77960_j()) || matchSize && stack1.field_77994_a != stack2.field_77994_a)) {
            if (stack1.func_77942_o() && stack2.func_77942_o()) {
                return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
            }
            return stack1.func_77942_o() == stack2.func_77942_o();
        }
        return false;
    }

    private static boolean isWildcard(int meta) {
        return meta == Short.MAX_VALUE;
    }

    public static IInventory getInventory(IInventory inventory) {
        if (inventory instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inventory;
            TileEntityChest adjacent = null;
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145990_j != null) {
                adjacent = chest.field_145990_j;
            }
            if (chest.field_145992_i != null) {
                adjacent = chest.field_145992_i;
            }
            if (chest.field_145988_l != null) {
                adjacent = chest.field_145988_l;
            }
            if (adjacent != null) {
                return new InventoryLargeChest("", inventory, (IInventory)adjacent);
            }
        }
        return inventory;
    }

    public static void dropInventoryContents(TileEntity tile) {
        if (tile == null || !(tile instanceof IInventory)) {
            return;
        }
        IInventory iinventory = (IInventory)tile;
        for (int i = 0; i < iinventory.func_70302_i_(); ++i) {
            ItemStack stack = iinventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || stack.field_77994_a <= 0) continue;
            Utils.dropStack(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, stack.func_77946_l());
            iinventory.func_70299_a(i, null);
        }
        tile.func_70296_d();
    }

    public static boolean inventoryContains(IInventory iinventory, ItemStack stack, boolean ignoreSize) {
        return Utils.inventoryContains(iinventory, stack, ignoreSize, Utils.getSlotsFromSide(iinventory, 0));
    }

    public static boolean inventoryContains(IInventory iinventory, ItemStack stack, boolean ignoreSize, int ... slots) {
        if (stack == null) {
            return false;
        }
        iinventory = Utils.getInventory(iinventory);
        int totalSize = 0;
        for (int slot : slots) {
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (Utils.areStacksTheSame(invtStack, stack, false)) {
                if (ignoreSize) {
                    return true;
                }
                totalSize += invtStack.field_77994_a;
            }
            if (totalSize < stack.field_77994_a) continue;
            return true;
        }
        return false;
    }

    public static boolean deleteFromInventory(IInventory iinventory, int side, ItemStack stack) {
        return Utils.deleteFromSlots(iinventory, stack, Utils.getSlotsFromSide(iinventory, side));
    }

    public static boolean deleteFromSlots(IInventory iinventory, ItemStack stack, int ... slots) {
        if (!Utils.inventoryContains(iinventory = Utils.getInventory(iinventory), stack, false)) {
            return false;
        }
        int totalDel = 0;
        for (int slot : slots) {
            ItemStack invtStack = iinventory.func_70301_a(slot);
            if (Utils.areStacksTheSame(invtStack, stack, false) || Utils.areStacksSameOre(invtStack, stack)) {
                if (invtStack.field_77994_a >= stack.field_77994_a) {
                    invtStack.field_77994_a -= stack.field_77994_a;
                    if (invtStack.field_77994_a <= 0) {
                        iinventory.func_70299_a(slot, Utils.getContainer(stack));
                    }
                    return true;
                }
                totalDel += invtStack.field_77994_a;
                iinventory.func_70299_a(slot, Utils.getContainer(stack));
            }
            if (totalDel != stack.field_77994_a) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getContainer(ItemStack stack) {
        return stack.func_77973_b().hasContainerItem(stack) ? stack.func_77973_b().getContainerItem(stack) : null;
    }

    public static final LinkedHashMap<Short, Short> getEnchantments(ItemStack stack) {
        NBTTagList list;
        LinkedHashMap<Short, Short> map = new LinkedHashMap<Short, Short>();
        NBTTagList nBTTagList = list = stack.func_77973_b() == Items.field_151134_bR ? Items.field_151134_bR.func_92110_g(stack) : stack.func_77986_q();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound tag = list.func_150305_b(i);
                map.put(tag.func_74765_d("id"), tag.func_74765_d("lvl"));
            }
        }
        return map;
    }
}

