/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.tileentity.TileEntitySlidingBlockPuzzle;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntitySlidingBlockPuzzleRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("erebus", "textures/blocks/anthillBlock.png");

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        TileEntitySlidingBlockPuzzle puzzleTile = (TileEntitySlidingBlockPuzzle)tile;
        ForgeDirection facing = puzzleTile.getFacing();
        TileEntitySlidingBlockPuzzle.SlidingPuzzle puzzle = puzzleTile.getPuzzle();
        TileEntitySlidingBlockPuzzle.SlidingPiece[] pieces = puzzleTile.getPieces();
        if (puzzle == null) {
            return;
        }
        this.func_147499_a(new ResourceLocation(puzzle.imagePath));
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        if (facing == ForgeDirection.WEST || facing == ForgeDirection.SOUTH) {
            GL11.glTranslated((double)facing.offsetX, (double)0.0, (double)facing.offsetZ);
        }
        GL11.glScalef((float)-0.0625f, (float)-0.0625f, (float)0.0625f);
        GL11.glTranslated((double)-16.0, (double)-16.0, (double)0.0);
        for (int i = 0; i < pieces.length; ++i) {
            TileEntitySlidingBlockPuzzle.SlidingPiece piece = pieces[i];
            if (piece.isEmpty()) continue;
            int xx = i % 2 * 8;
            int yy = i / 2 * 8;
            int width = 8;
            int height = 8;
            double uvSize = 0.1666666716337204;
            double uu = (float)piece.getU() / 6.0f;
            double vv = (float)piece.getV() / 6.0f;
            this.drawFace(facing, xx, yy, width, height, uu, vv, uvSize);
        }
        this.func_147499_a(BACKGROUND_TEXTURE);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(16 * facing.offsetX), (double)0.0, (double)(16 * -facing.offsetZ));
        this.drawFace(facing.getOpposite(), 0.0f, 0.0f, 16.0f, 16.0f, 0.0, 0.0, 1.0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)facing.offsetX, (double)0.0, (double)(-facing.offsetZ));
        this.drawFace(facing, 0.0f, 0.0f, 16.0f, 16.0f, 0.0, 0.0, 1.0);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private void drawFace(ForgeDirection facing, float xx, float yy, float width, float height, double uu, double vv, double uvSize) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        switch (facing) {
            case WEST: {
                tessellator.func_78374_a(0.0, (double)(yy + height), (double)(xx + 0.0f), uu + 0.0, vv + uvSize);
                tessellator.func_78374_a(0.0, (double)(yy + height), (double)(xx + width), uu + uvSize, vv + uvSize);
                tessellator.func_78374_a(0.0, (double)(yy + 0.0f), (double)(xx + width), uu + uvSize, vv + 0.0);
                tessellator.func_78374_a(0.0, (double)(yy + 0.0f), (double)(xx + 0.0f), uu + 0.0, vv + 0.0);
                break;
            }
            case EAST: {
                tessellator.func_78374_a(0.0, (double)(yy + 0.0f), (double)(xx + 0.0f), uu + uvSize, vv + 0.0);
                tessellator.func_78374_a(0.0, (double)(yy + 0.0f), (double)(xx + width), uu + 0.0, vv + 0.0);
                tessellator.func_78374_a(0.0, (double)(yy + height), (double)(xx + width), uu + 0.0, vv + uvSize);
                tessellator.func_78374_a(0.0, (double)(yy + height), (double)(xx + 0.0f), uu + uvSize, vv + uvSize);
                break;
            }
            case SOUTH: {
                tessellator.func_78374_a((double)(xx + 0.0f), (double)(yy + 0.0f), 0.0, uu + uvSize, vv + 0.0);
                tessellator.func_78374_a((double)(xx + width), (double)(yy + 0.0f), 0.0, uu + 0.0, vv + 0.0);
                tessellator.func_78374_a((double)(xx + width), (double)(yy + height), 0.0, uu + 0.0, vv + uvSize);
                tessellator.func_78374_a((double)(xx + 0.0f), (double)(yy + height), 0.0, uu + uvSize, vv + uvSize);
                break;
            }
            case NORTH: {
                tessellator.func_78374_a((double)(xx + 0.0f), (double)(yy + height), 0.0, uu + 0.0, vv + uvSize);
                tessellator.func_78374_a((double)(xx + width), (double)(yy + height), 0.0, uu + uvSize, vv + uvSize);
                tessellator.func_78374_a((double)(xx + width), (double)(yy + 0.0f), 0.0, uu + uvSize, vv + 0.0);
                tessellator.func_78374_a((double)(xx + 0.0f), (double)(yy + 0.0f), 0.0, uu + 0.0, vv + 0.0);
                break;
            }
        }
        tessellator.func_78381_a();
    }
}

