/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.client.model.block.ModelGlowingJar;
import erebus.tileentity.TileEntityGlowingJar;
import erebus.tileentity.TileEntityJarOHoney;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityGlowingJarRenderer
extends TileEntitySpecialRenderer {
    private final ModelGlowingJar glowingJar = new ModelGlowingJar();
    private final RenderItem renderItem;
    private final RenderBlocks blockRenderer = new RenderBlocks();
    private static final ResourceLocation GLOWING_JAR = new ResourceLocation("erebus:textures/special/tiles/glowingJar.png");
    public static TileEntityGlowingJarRenderer instance;

    public TileEntityGlowingJarRenderer() {
        this.renderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }
        };
        this.renderItem.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_147497_a(TileEntityRendererDispatcher renderer) {
        super.func_147497_a(renderer);
        instance = this;
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        if (tile instanceof TileEntityJarOHoney) {
            this.renderJarOHoney((TileEntityJarOHoney)tile, x, y, z);
        } else if (tile instanceof TileEntityGlowingJar) {
            this.renderGlowJar(x, y, z, ((TileEntityGlowingJar)tile).getGhostItem());
        }
        this.renderJar(x, y, z);
    }

    public void renderJarOHoney(TileEntityJarOHoney tile, double x, double y, double z) {
        int amount = tile.tank.getFluidAmount();
        int capacity = tile.tank.getCapacity();
        float size = 0.7f / (float)capacity * (float)amount;
        if (amount >= 100) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTranslated((double)((float)x + 0.5f), (double)((float)(y + (double)0.03f + (double)(size * 0.5f))), (double)((float)z + 0.5f));
            GL11.glScalef((float)0.55f, (float)(-size), (float)-0.55f);
            this.func_147499_a(TextureMap.field_110575_b);
            this.blockRenderer.func_147800_a(ModBlocks.amber, 0, 1.0f);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
        this.renderNameTag(tile.getOwnerName(), x, y, z);
    }

    public void renderGlowJar(double x, double y, double z, EntityItem ghostItem) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)(y + (double)0.2f)), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.2f, (float)1.2f, (float)1.2f);
        this.renderItem.func_76986_a(ghostItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderItem.func_76986_a(ghostItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    public void renderJar(double x, double y, double z) {
        this.func_147499_a(GLOWING_JAR);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.51f), (float)((float)z + 0.5f));
        GL11.glScalef((float)0.7f, (float)-1.0f, (float)-0.7f);
        GL11.glDisable((int)2884);
        this.glowingJar.render();
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
    }

    private void renderNameTag(String name, double x, double y, double z) {
        float scale = 0.02666667f;
        float height = 0.8f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + (double)height + 0.5), (double)(z + 0.5));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontrenderer.func_78256_a(name) / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.func_78377_a((double)(-width - 1), -1.0, 0.0);
        tessellator.func_78377_a((double)(-width - 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(width + 1), 8.0, 0.0);
        tessellator.func_78377_a((double)(width + 1), -1.0, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, 0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.func_78276_b(name, -fontrenderer.func_78256_a(name) / 2, 0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

