/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModItems;
import erebus.client.model.item.ModelWebSlinger;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class WebSlingerItemRenderer
implements IItemRenderer {
    private final ModelWebSlinger model = new ModelWebSlinger();
    private final ResourceLocation WEB_SLINGER = new ResourceLocation("erebus:textures/special/items/webSlinger.png");
    private final ResourceLocation WITHER_WEB_SLINGER = new ResourceLocation("erebus:textures/special/items/webWitherSlinger.png");

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        ResourceLocation texture = item.func_77973_b() == ModItems.webSlinger ? this.WEB_SLINGER : this.WITHER_WEB_SLINGER;
        switch (type) {
            case ENTITY: {
                this.renderWebSlinger(0.0f, 0.5f, 0.0f, 0.5, texture);
                break;
            }
            case EQUIPPED: {
                this.renderEquipped(-0.8f, -1.6f, -1.25f, 1.5, texture);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderWebSlingerFirstPerson(1.0f, 1.0f, 0.0f, 2.5, texture);
                break;
            }
            case INVENTORY: {
                this.renderWebSlingerInventory(-0.3f, 0.3f, 0.0f, 0.9, texture);
                break;
            }
        }
    }

    private void renderEquipped(float x, float y, float z, double size, ResourceLocation texture) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texture);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)120.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.model.render();
        GL11.glPopMatrix();
    }

    private void renderWebSlinger(float x, float y, float z, double size, ResourceLocation texture) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texture);
        if (RenderItem.field_82407_g) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)-1.0f);
            GL11.glScaled((double)0.7f, (double)0.7f, (double)0.7f);
            this.model.render();
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)z);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScaled((double)size, (double)size, (double)size);
            this.model.render();
            GL11.glPopMatrix();
        }
    }

    private void renderWebSlingerFirstPerson(float x, float y, float z, double size, ResourceLocation texture) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-160.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.model.render();
        GL11.glPopMatrix();
    }

    private void renderWebSlingerInventory(float x, float y, float z, double size, ResourceLocation texture) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(texture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-35.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)size, (double)size, (double)size);
        this.model.render();
        GL11.glPopMatrix();
    }
}

