/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.silo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.block.silo.TileEntitySiloTank;
import erebus.core.helper.Utils;
import erebus.core.proxy.CommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSiloTank
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon siloTankActive;

    public BlockSiloTank(Material material) {
        super(material);
        this.func_149647_a(ModTabs.blocks);
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tile;
        if (this.isSiloComplete(world, x, y, z) && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileEntitySiloTank) {
            ((TileEntitySiloTank)tile).setActive(true);
            world.func_72921_c(x, y, z, 1, 3);
            return;
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        TileEntity tile;
        if (this.isSiloComplete(world, x, y, z)) {
            TileEntity tile2 = world.func_147438_o(x, y, z);
            if (tile2 != null && tile2 instanceof TileEntitySiloTank) {
                ((TileEntitySiloTank)tile2).setActive(true);
                world.func_72921_c(x, y, z, 1, 3);
            }
        } else if (!this.isSiloComplete(world, x, y, z) && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileEntitySiloTank) {
            ((TileEntitySiloTank)tile).setActive(false);
            world.func_72921_c(x, y, z, 0, 3);
            this.func_149749_a(world, x, y, z, (Block)this, 0);
            this.func_149697_b(world, x, y, z, 0, 0);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntitySiloTank) {
            ItemStack current = player.field_71071_by.func_70448_g();
            if (current != null && current.func_77973_b() == Item.func_150898_a((Block)ModBlocks.siloRoof)) {
                return false;
            }
            if (this.isSiloComplete(world, x, y, z)) {
                player.openGui((Object)Erebus.instance, CommonProxy.GuiID.SILO_INVENTORY.ordinal(), world, x, y, z);
                return true;
            }
        }
        return true;
    }

    public boolean isSiloComplete(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == ModBlocks.siloSupports && world.func_147439_a(x, y + 1, z) == ModBlocks.siloRoof;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == ModBlocks.siloSupports;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149742_c(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntitySiloTank tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntitySiloTank.class);
        if (tile != null) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                ItemStack is = tile.func_70301_a(i);
                if (is == null) continue;
                Utils.dropStack(world, x, y, z, is);
            }
        }
        world.func_147468_f(x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta == 1 ? this.siloTankActive : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("erebus:siloTankInactive");
        this.siloTankActive = reg.func_94245_a("erebus:siloTankActive");
    }

    public int func_149645_b() {
        return 0;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySiloTank();
    }
}

