/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.core.proxy.ClientProxy;
import erebus.item.ItemMaterials;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;

public class DoubleHeightPlant
extends BlockDoublePlant
implements IShearable {
    @SideOnly(value=Side.CLIENT)
    private IIcon top;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottom;
    private final String name;

    public DoubleHeightPlant(String name) {
        this(name, 1.0f);
    }

    public DoubleHeightPlant(String name, float width) {
        this.name = name;
        this.func_149647_a(ModTabs.plants);
        this.func_149672_a(Block.field_149779_h);
        float w = (1.0f - width) / 2.0f;
        this.func_149676_a(w, 0.0f, w, width + w, 1.0f, width + w);
        this.func_149663_c("erebus." + name.substring(0, 1).toLowerCase() + name.substring(1));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (world.field_73012_v.nextInt(8) != 0) {
            return drops;
        }
        if ("Sundew".equals(this.name)) {
            drops.add(new ItemStack(ModItems.materials, 1, ItemMaterials.DATA.BIO_LUMINESCENCE.ordinal()));
        } else if ("WeepingBlue".equals(this.name)) {
            drops.add(new ItemStack(ModItems.materials, 1, ItemMaterials.DATA.WEEPING_BLUE_PETAL.ordinal()));
        } else if ("Bullrush".equals(this.name)) {
            drops.add(new ItemStack(ModItems.materials, 1, ItemMaterials.DATA.PAPYRUS.ordinal()));
        } else if ("WaterFlower".equals(this.name)) {
            drops.add(new ItemStack((Block)this));
        } else {
            ItemStack seed = ForgeHooks.getGrassSeed((World)world);
            if (seed != null) {
                drops.add(seed);
            }
        }
        return drops;
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.DOUBLE_PLANTS.id();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.top;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return DoubleHeightPlant.func_149887_c((int)world.func_72805_g(x, y, z)) ? this.top : this.bottom;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.top = reg.func_94245_a("erebus:doublePlant" + this.name + "Top");
        this.bottom = reg.func_94245_a("erebus:doublePlant" + this.name + "Bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item));
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) & 7));
        return ret;
    }
}

