/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.item.ItemErebusFood;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPricklyPair
extends Block
implements IPlantable {
    @SideOnly(value=Side.CLIENT)
    private IIcon top;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottom;

    public BlockPricklyPair() {
        super(Material.field_151585_k);
        this.func_149663_c("erebus.pricklyPair");
        this.func_149658_d("erebus:prickly_pair");
        this.func_149647_a(ModTabs.plants);
        float f = 0.375f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        this.func_149675_a(true);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if ((world.func_147439_a(x, y - 1, z) == ModBlocks.pricklyPair || this.dropBlockIfCantStay(world, x, y, z)) && world.func_147437_c(x, y + 1, z)) {
            int height = 1;
            while (world.func_147439_a(x, y - height, z) == this) {
                ++height;
            }
            if (height < 3) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 10) {
                    world.func_147449_b(x, y + 1, z, (Block)this);
                    if (world.func_147439_a(x, y, z) == this && world.func_147439_a(x, y - 1, z) == this) {
                        world.func_72921_c(x, y + 1, z, 11, 4);
                    } else {
                        world.func_72921_c(x, y, z, 0, 4);
                    }
                } else if (meta < 10) {
                    world.func_72921_c(x, y, z, meta + 1, 4);
                }
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        return block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.dropBlockIfCantStay(world, x, y, z);
    }

    protected final boolean dropBlockIfCantStay(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.func_149742_c(world, x, y, z) || world.func_147439_a(x, y - 1, z) == this;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (meta <= 10) {
            drops.add(new ItemStack(Item.func_150898_a((Block)this)));
        } else {
            drops.add(new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.PRICKLY_PAIR_RAW.ordinal()));
        }
        return drops;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return meta <= 10 ? this.bottom : this.top;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.top = reg.func_94245_a("erebus:prickly_pair_fruited");
        this.bottom = reg.func_94245_a("erebus:prickly_pair");
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Desert;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }
}

