/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.core.helper.Utils;
import erebus.item.ItemErebusFood;
import erebus.item.ItemMaterials;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBerryBush
extends Block {
    private String type;
    @SideOnly(value=Side.CLIENT)
    private IIcon fastIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon fastFruitIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon fruitIcon;

    public BlockBerryBush(String bushType) {
        super(Material.field_151585_k);
        this.type = bushType;
        this.func_149663_c("erebus." + this.type + "BerryBush");
        this.func_149658_d("erebus:" + this.type + "BerryBush");
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149647_a(ModTabs.plants);
        this.func_149672_a(Block.field_149779_h);
    }

    public int func_149738_a(World world) {
        return 10;
    }

    public int func_149645_b() {
        return 0;
    }

    public String func_149732_F() {
        return String.format(StatCollector.func_74838_a((String)("tile.erebus." + this.type + "BerryBush.name")), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta > 2) {
            return Minecraft.func_71410_x().field_71474_y.field_74347_j ? this.fruitIcon : this.fastFruitIcon;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74347_j ? this.field_149761_L : this.fastIcon;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "Fancy");
        this.fastIcon = reg.func_94245_a(this.func_149641_N() + "Fast");
        this.fruitIcon = reg.func_94245_a(this.func_149641_N() + "FruitedFancy");
        this.fastFruitIcon = reg.func_94245_a(this.func_149641_N() + "FruitedFast");
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        int meta = access.func_72805_g(x, y, z);
        float widthReduced = 0.0f;
        float heightReduced = 0.0f;
        switch (meta) {
            case 0: {
                widthReduced = 0.25f;
                heightReduced = 0.5f;
                break;
            }
            case 1: {
                widthReduced = 0.125f;
                heightReduced = 0.25f;
                break;
            }
            case 2: {
                widthReduced = 0.0f;
                heightReduced = 0.0f;
                break;
            }
            case 3: {
                widthReduced = 0.0f;
                heightReduced = 0.0f;
            }
        }
        this.func_149676_a(widthReduced, 0.0f, widthReduced, 1.0f - widthReduced, 1.0f - heightReduced, 1.0f - widthReduced);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (rand.nextInt(25) == 0) {
            switch (meta) {
                case 0: {
                    world.func_147465_d(x, y, z, (Block)this, 1, 2);
                    break;
                }
                case 1: {
                    world.func_147465_d(x, y, z, (Block)this, 2, 2);
                }
            }
        }
        if (meta == 2 && rand.nextInt(50) == 0) {
            world.func_147465_d(x, y, z, (Block)this, 3, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3) {
            world.func_72956_a((Entity)player, "random.pop", 0.5f, 2.0f);
            if (!player.field_71071_by.func_70441_a(this.getBerry())) {
                Utils.dropStack(world, (int)((double)x + 0.5), (int)((double)y + 0.5), (int)((double)z + 0.5), this.getBerry());
            }
            world.func_147465_d(x, y, z, (Block)this, 2, 2);
            return true;
        }
        return true;
    }

    public void func_149681_a(World world, int x, int y, int z, int id, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 3) {
            Utils.dropStack(world, (int)((double)x + 0.5), (int)((double)y + 0.5), (int)((double)z + 0.5), this.getBerry());
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.isValidBlock(world.func_147439_a(x, y - 1, z)) && this.func_149718_j(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.isValidBlock(world.func_147439_a(x, y - 1, z));
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        int meta = world.func_72805_g(x, y, z);
        if (world.func_147437_c(x, y - 1, z)) {
            if (meta == 3) {
                Utils.dropStack(world, (int)((double)x + 0.5), (int)((double)y + 0.5), (int)((double)z + 0.5), this.getBerry());
            }
            Utils.dropStack(world, (int)((double)x + 0.5), (int)((double)y + 0.5), (int)((double)z + 0.5), new ItemStack(Item.func_150898_a((Block)this)));
            world.func_147468_f(x, y, z);
        }
        this.func_149718_j(world, x, y, z);
    }

    private boolean isValidBlock(Block block) {
        return block != null && block == ModBlocks.mud || block == Blocks.field_150458_ak;
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public ItemStack getBerry() {
        ItemStack item = null;
        if (this.type == "jade") {
            item = new ItemStack(ModItems.materials, 1, ItemMaterials.DATA.JADE_BERRIES.ordinal());
        }
        if (this.type == "heart") {
            item = new ItemStack(ModItems.heartBerries, 1);
        }
        if (this.type == "swamp") {
            item = new ItemStack(ModItems.food, 1, ItemErebusFood.FoodType.SWAMPBERRIES.ordinal());
        }
        return item;
    }
}

