/*
 * Decompiled with CFR 0.152.
 */
package erebus.block.bamboo;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import erebus.ModTabs;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBambooTorch
extends Block {
    public static final String[] iconPaths = new String[]{"bambooTorchLower", "bambooTorch", "bambooTorchTop", "bambooTorchBottom"};
    public static IIcon[] icons;

    public BlockBambooTorch() {
        super(Material.field_151575_d);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9f);
        this.func_149647_a(ModTabs.blocks);
        this.func_149663_c("erebus.bambooTorch");
        this.func_149676_a(0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        icons = new IIcon[iconPaths.length];
        int i = 0;
        for (String path : iconPaths) {
            BlockBambooTorch.icons[i++] = iconRegister.func_94245_a("erebus:" + path);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= icons.length) {
            return null;
        }
        if (meta == 0) {
            return side > 1 ? icons[0] : icons[3];
        }
        if (meta == 1) {
            return side > 1 ? icons[1] : icons[2];
        }
        return null;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == null || !world.func_147437_c(x, y + 1, z)) {
            return false;
        }
        if (block == this && (world.func_72805_g(x, y - 1, z) & 7) == 7) {
            return true;
        }
        if (block.isLeaves((IBlockAccess)world, x, y - 1, z)) {
            return false;
        }
        world.func_147465_d(x, y + 1, z, (Block)this, 1, 3);
        return block.func_149688_o().func_76230_c();
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        this.dropTorchIfCantStay(world, x, y, z);
    }

    protected boolean dropTorchIfCantStay(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y + 1, z);
        if (world.func_147437_c(x, y - 1, z)) {
            world.func_147468_f(x, y, z);
            if (meta == 0) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            }
            return false;
        }
        return true;
    }

    public void func_149681_a(World world, int x, int y, int z, int id, EntityPlayer player) {
        if (world.func_147439_a(x, y - 1, z) == this) {
            world.func_147468_f(x, y - 1, z);
        }
        if (world.func_147439_a(x, y + 1, z) == this) {
            world.func_147468_f(x, y + 1, z);
        }
        if (world.func_147439_a(x, y + 1, z) == this || world.func_147439_a(x, y - 1, z) == this) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        }
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            double d0 = (float)x + 0.4375f;
            double d1 = (float)y + 2.0625f;
            double d2 = (float)z + 0.4375f;
            double d3 = (float)x + 0.5625f;
            double d4 = (float)z + 0.5625f;
            double d5 = (float)x + 0.5f;
            double d6 = (float)y + 2.25f;
            double d7 = (float)z + 0.5f;
            world.func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", d0, d1, d4, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d0, d1, d4, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", d3, d1, d2, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d3, d1, d2, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", d3, d1, d4, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d3, d1, d4, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", d5, d6, d7, 0.0, 0.0, 0.0);
            world.func_72869_a("flame", d5, d6, d7, 0.0, 0.0, 0.0);
        }
    }
}

