/*
 * Decompiled with CFR 0.152.
 */
package erebus;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import erebus.ModAchievements;
import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.ModEntities;
import erebus.ModFluids;
import erebus.ModItems;
import erebus.api.ErebusAPI;
import erebus.client.gui.GuiAntiVenomBar;
import erebus.client.gui.RenderWarHammerChargeBar;
import erebus.client.render.entity.MobGrabbingHealthBarRemoval;
import erebus.client.render.entity.RenderRhinoBeetleChargeBar;
import erebus.client.sound.ErebusMusicHandler;
import erebus.core.handler.AntiVenomDurationHandler;
import erebus.core.handler.AnvilEventsHandler;
import erebus.core.handler.BedPlaceEventHandler;
import erebus.core.handler.BucketFillHandler;
import erebus.core.handler.DeathCompassRespawnEvent;
import erebus.core.handler.EntityConstructingEvent;
import erebus.core.handler.EntityDeathInventoryHandler;
import erebus.core.handler.EntityPickupEventHandler;
import erebus.core.handler.EntityPlayerSpawnHandler;
import erebus.core.handler.ErebusPlayerLoggedInEvent;
import erebus.core.handler.FurnaceBurnTimeHandler;
import erebus.core.handler.HomingBeeconTextureHandler;
import erebus.core.handler.PlayerInWallDamageHandler;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.proxy.CommonProxy;
import erebus.debug.ErebusCommandDebug;
import erebus.entity.util.RandomMobNames;
import erebus.integration.FMPIntegration;
import erebus.integration.ModIntegrationHandler;
import erebus.integration.ThaumcraftIntegration;
import erebus.network.PacketPipeline;
import erebus.preserved.PreservableEntityRegistry;
import erebus.recipes.ComposterRegistry;
import erebus.recipes.ErebusRecipesHandler;
import erebus.recipes.RecipeHandler;
import erebus.world.SpawnerErebus;
import erebus.world.WorldProviderErebus;
import erebus.world.feature.structure.WorldGenAntlionMaze;
import erebus.world.teleporter.TeleporterHandler;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="erebus", name="Erebus", version="0.4.7", dependencies="required-after:Forge@[10.13.4.1566,);", guiFactory="erebus.core.handler.configs.ConfigGuiFactory")
public class Erebus {
    @SidedProxy(clientSide="erebus.core.proxy.ClientProxy", serverSide="erebus.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="erebus")
    public static Erebus instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ErebusAPI.preservableEntityRegistry = PreservableEntityRegistry.INSTANCE;
        ConfigHandler.INSTANCE.loadConfig(event);
        if (event.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new RenderRhinoBeetleChargeBar());
            MinecraftForge.EVENT_BUS.register((Object)new RenderWarHammerChargeBar());
            MinecraftForge.EVENT_BUS.register((Object)new HomingBeeconTextureHandler());
            MinecraftForge.EVENT_BUS.register((Object)new MobGrabbingHealthBarRemoval());
            if (ConfigHandler.INSTANCE.playCustomSongs) {
                FMLCommonHandler.instance().bus().register((Object)new ErebusMusicHandler());
            }
            MinecraftForge.EVENT_BUS.register((Object)new GuiAntiVenomBar());
        }
        ModFluids.init();
        ModBlocks.init();
        ModItems.init();
        ModEntities.init();
        ConfigHandler.INSTANCE.initOreConfigs();
        AchievementPage.registerAchievementPage((AchievementPage)new ModAchievements());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        DimensionManager.registerProviderType((int)ConfigHandler.INSTANCE.erebusDimensionID, WorldProviderErebus.class, (boolean)true);
        DimensionManager.registerDimension((int)ConfigHandler.INSTANCE.erebusDimensionID, (int)ConfigHandler.INSTANCE.erebusDimensionID);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenAntlionMaze(), (int)0);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ArrayList<IRecipe> doorRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack stack;
            if (recipe == null || (stack = recipe.func_77571_b()) == null || stack.func_77973_b() != Items.field_151135_aq) continue;
            doorRecipes.add(recipe);
        }
        for (IRecipe recipe : doorRecipes) {
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
        }
        proxy.registerKeyHandlers();
        proxy.registerTileEntities();
        proxy.registerRenderInformation();
        PacketPipeline.initializePipeline();
        ModBiomes.init();
        RecipeHandler.init();
        ErebusRecipesHandler.init();
        TeleporterHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new EntityPickupEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BucketFillHandler());
        MinecraftForge.EVENT_BUS.register((Object)ModBlocks.quickSand);
        MinecraftForge.EVENT_BUS.register((Object)ModFluids.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ModItems.armorGlider);
        MinecraftForge.EVENT_BUS.register((Object)ModItems.jumpBoots);
        MinecraftForge.EVENT_BUS.register((Object)ModBlocks.preservedBlock);
        MinecraftForge.EVENT_BUS.register((Object)new AnvilEventsHandler());
        FMLCommonHandler.instance().bus().register((Object)ConfigHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)SpawnerErebus.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new FurnaceBurnTimeHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BedPlaceEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerInWallDamageHandler());
        FMLCommonHandler.instance().bus().register((Object)new AntiVenomDurationHandler());
        if (ConfigHandler.INSTANCE.allowRespawning) {
            FMLCommonHandler.instance().bus().register((Object)new ErebusPlayerLoggedInEvent());
            MinecraftForge.EVENT_BUS.register((Object)new EntityPlayerSpawnHandler());
        }
        if (ConfigHandler.INSTANCE.graveMarker) {
            MinecraftForge.EVENT_BUS.register((Object)new EntityDeathInventoryHandler());
            MinecraftForge.EVENT_BUS.register((Object)new EntityConstructingEvent());
            MinecraftForge.EVENT_BUS.register((Object)new DeathCompassRespawnEvent());
        }
        if (ConfigHandler.INSTANCE.randomNames) {
            MinecraftForge.EVENT_BUS.register((Object)RandomMobNames.instance);
        }
        if (!ConfigHandler.INSTANCE.disableThaumcraft) {
            ModIntegrationHandler.addMod(ThaumcraftIntegration.class);
        }
        if (!ConfigHandler.INSTANCE.disableFMP) {
            ModIntegrationHandler.addMod(FMPIntegration.class);
        }
        ModIntegrationHandler.init();
        ComposterRegistry.init();
        CraftingManager.func_77594_a().func_77592_b().addAll(doorRecipes);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModIntegrationHandler.postInit();
        ModBiomes.postInit();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ErebusCommandDebug());
    }
}

