/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.platform;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.Name;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.platform.JvmBuiltIns;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.platform.PlatformToKotlinClassMap;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public class JavaToKotlinClassMap
implements PlatformToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE = new JavaToKotlinClassMap();
    private final Map<FqName, ClassDescriptor> javaToKotlin = new HashMap<FqName, ClassDescriptor>();
    private final Map<FqNameUnsafe, ClassId> kotlinToJava = new HashMap<FqNameUnsafe, ClassId>();
    private final Map<ClassDescriptor, ClassDescriptor> mutableToReadOnly = new HashMap<ClassDescriptor, ClassDescriptor>();
    private final Map<ClassDescriptor, ClassDescriptor> readOnlyToMutable = new HashMap<ClassDescriptor, ClassDescriptor>();
    private final CompanionObjectMapping companionObjectMapping;

    private JavaToKotlinClassMap() {
        KotlinBuiltIns builtIns = JvmBuiltIns.getInstance();
        this.add(Object.class, builtIns.getAny());
        this.add(String.class, builtIns.getString());
        this.add(CharSequence.class, builtIns.getCharSequence());
        this.add(Throwable.class, builtIns.getThrowable());
        this.add(Cloneable.class, builtIns.getCloneable());
        this.add(Number.class, builtIns.getNumber());
        this.add(Comparable.class, builtIns.getComparable());
        this.add(Enum.class, builtIns.getEnum());
        this.add(Annotation.class, builtIns.getAnnotation());
        this.add(Iterable.class, builtIns.getIterable(), builtIns.getMutableIterable());
        this.add(Iterator.class, builtIns.getIterator(), builtIns.getMutableIterator());
        this.add(Collection.class, builtIns.getCollection(), builtIns.getMutableCollection());
        this.add(List.class, builtIns.getList(), builtIns.getMutableList());
        this.add(Set.class, builtIns.getSet(), builtIns.getMutableSet());
        this.add(Map.class, builtIns.getMap(), builtIns.getMutableMap());
        this.add(Map.Entry.class, builtIns.getMapEntry(), builtIns.getMutableMapEntry());
        this.add(ListIterator.class, builtIns.getListIterator(), builtIns.getMutableListIterator());
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            this.add(ClassId.topLevel(jvmType.getWrapperFqName()), builtIns.getPrimitiveClassDescriptor(jvmType.getPrimitiveType()));
        }
        this.companionObjectMapping = new CompanionObjectMapping(builtIns);
        for (ClassDescriptor descriptor2 : this.companionObjectMapping.allClassesWithIntrinsicCompanions()) {
            ClassDescriptor companion = descriptor2.getCompanionObjectDescriptor();
            assert (companion != null) : "No companion object found for " + descriptor2;
            this.add(ClassId.topLevel(new FqName("me.modmuss50.fr.repack.kotlin.jvm.internal." + descriptor2.getName().asString() + "CompanionObject")), companion);
        }
        for (int i = 0; i < 23; ++i) {
            this.add(ClassId.topLevel(new FqName("me.modmuss50.fr.repack.kotlin.jvm.functions.Function" + i)), builtIns.getFunction(i));
            FunctionClassDescriptor.Kind kFunction = FunctionClassDescriptor.Kind.KFunction;
            String kFun = kFunction.getPackageFqName() + "." + kFunction.getClassNamePrefix();
            this.addKotlinToJava(new FqNameUnsafe(kFun + i), ClassId.topLevel(new FqName(kFun)));
        }
        this.addKotlinToJava(builtIns.getNothing(), JavaToKotlinClassMap.classId(Void.class));
    }

    @Nullable
    public ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapJavaToKotlin"));
        }
        return this.javaToKotlin.get(fqName2);
    }

    @Nullable
    public ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinFqName", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapKotlinToJava"));
        }
        return this.kotlinToJava.get(kotlinFqName);
    }

    public boolean isMappedCompanion(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isMappedCompanion"));
        }
        return this.companionObjectMapping.hasMappingToObject(descriptor2);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinMutableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinMutableDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        ClassId javaClassId = JavaToKotlinClassMap.classId(javaClass);
        this.add(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(kotlinMutableDescriptor, javaClassId);
        this.mutableToReadOnly.put(kotlinMutableDescriptor, kotlinDescriptor);
        this.readOnlyToMutable.put(kotlinDescriptor, kotlinMutableDescriptor);
    }

    private void add(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        this.addJavaToKotlin(javaClassId, kotlinDescriptor);
        this.addKotlinToJava(kotlinDescriptor, javaClassId);
    }

    private void add(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "add"));
        }
        this.add(JavaToKotlinClassMap.classId(javaClass), kotlinDescriptor);
    }

    private void addJavaToKotlin(@NotNull ClassId javaClassId, @NotNull ClassDescriptor kotlinDescriptor) {
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addJavaToKotlin"));
        }
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addJavaToKotlin"));
        }
        this.javaToKotlin.put(javaClassId.asSingleFqName(), kotlinDescriptor);
    }

    private void addKotlinToJava(@NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassId javaClassId) {
        if (kotlinDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        this.addKotlinToJava(DescriptorUtils.getFqName(kotlinDescriptor), javaClassId);
    }

    private void addKotlinToJava(@NotNull FqNameUnsafe kotlinFqName, @NotNull ClassId javaClassId) {
        if (kotlinFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "me.modmuss50.fr.repack.kotlinFqName", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        if (javaClassId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClassId", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "addKotlinToJava"));
        }
        this.kotlinToJava.put(kotlinFqName, javaClassId);
    }

    @NotNull
    private static ClassId classId(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "classId"));
        }
        assert (!clazz.isPrimitive() && !clazz.isArray()) : "Invalid class: " + clazz;
        Class<?> outer = clazz.getDeclaringClass();
        ClassId classId = outer == null ? ClassId.topLevel(new FqName(clazz.getCanonicalName())) : JavaToKotlinClassMap.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "classId"));
        }
        return classId;
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        ClassDescriptor kotlinAnalog = this.mapJavaToKotlin(fqName2);
        if (kotlinAnalog == null) {
            Set<ClassDescriptor> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return set;
        }
        ClassDescriptor kotlinMutableAnalog = this.readOnlyToMutable.get(kotlinAnalog);
        if (kotlinMutableAnalog == null) {
            Set<ClassDescriptor> set = Collections.singleton(kotlinAnalog);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
            }
            return set;
        }
        List<ClassDescriptor> list = Arrays.asList(kotlinAnalog, kotlinMutableAnalog);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        FqNameUnsafe className = DescriptorUtils.getFqName(classDescriptor);
        Collection<ClassDescriptor> collection = className.isSafe() ? this.mapPlatformClass(className.toSafe()) : Collections.emptySet();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "mapPlatformClass"));
        }
        return collection;
    }

    public boolean isMutable(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isMutable"));
        }
        return this.mutableToReadOnly.containsKey(mutable);
    }

    public boolean isMutable(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isMutable"));
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isMutable(classDescriptor);
    }

    public boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isReadOnly"));
        }
        return this.readOnlyToMutable.containsKey(readOnly);
    }

    public boolean isReadOnly(@NotNull KotlinType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "isReadOnly"));
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        return classDescriptor != null && this.isReadOnly(classDescriptor);
    }

    @NotNull
    public ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        if (mutable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutable", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertMutableToReadOnly"));
        }
        ClassDescriptor readOnly = this.mutableToReadOnly.get(mutable);
        if (readOnly == null) {
            throw new IllegalArgumentException("Given class " + mutable + " is not a mutable collection");
        }
        ClassDescriptor classDescriptor = readOnly;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertMutableToReadOnly"));
        }
        return classDescriptor;
    }

    @NotNull
    public ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        if (readOnly == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readOnly", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertReadOnlyToMutable"));
        }
        ClassDescriptor mutable = this.readOnlyToMutable.get(readOnly);
        if (mutable == null) {
            throw new IllegalArgumentException("Given class " + readOnly + " is not a read-only collection");
        }
        ClassDescriptor classDescriptor = mutable;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/platform/JavaToKotlinClassMap", "convertReadOnlyToMutable"));
        }
        return classDescriptor;
    }
}

