/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.registry;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.IFluidBlock;
import tinker_io.api.MeshDefinitionFix;
import tinker_io.registry.FluidRegister;

public class FluidRenderRegister {
    private static final String FLUID_MODEL_PATH = "tinker_io:fluid";

    public static void fluidModelRegister() {
        FluidRenderRegister.registerFluid(FluidRegister.blockPureMetal);
        System.out.println("[Tinker I/O] Fluid Model loaded!");
    }

    public static void registerFluid(BlockFluidClassic blockFluid) {
        Item item = Item.func_150898_a((Block)blockFluid);
        String name = blockFluid.getFluid().getName();
        final ModelResourceLocation modleLoc = new ModelResourceLocation(FLUID_MODEL_PATH);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return modleLoc;
            }
        });
        ModelLoader.setCustomStateMapper((Block)blockFluid, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modleLoc;
            }
        });
        System.out.println("TIO/TIO");
    }

    public static void registerFluidModel(IFluidBlock fluidBlock) {
        Item item = Item.func_150898_a((Block)((Block)fluidBlock));
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(FLUID_MODEL_PATH, fluidBlock.getFluid().getName())});
        System.out.println("[TIO] " + fluidBlock.getFluid().getName());
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(FLUID_MODEL_PATH, fluidBlock.getFluid().getName());
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)MeshDefinitionFix.create(stack -> modelResourceLocation));
        ModelLoader.setCustomStateMapper((Block)((Block)fluidBlock), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState p_178132_1_) {
                return modelResourceLocation;
            }
        });
    }
}

