/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity.fim;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import tinker_io.TileEntity.fim.Adapter;
import tinker_io.TileEntity.fim.FIMNeighborBlocksManager;
import tinker_io.TileEntity.fim.SCTileAdapter;
import tinker_io.api.vanilla.PosInfo;

public class SCInfo {
    private final BlockPos FIMBlockPos;
    private final World worldObj;
    public BlockPos pos;
    public List<BlockPos> posList;
    public FIMNeighborBlocksManager manager;
    private boolean initFlag = false;

    public SCInfo(BlockPos FIMBlockPos, World worldObj) {
        this.FIMBlockPos = FIMBlockPos;
        this.worldObj = worldObj;
        this.manager = new FIMNeighborBlocksManager((IBlockAccess)worldObj, FIMBlockPos);
    }

    public boolean canFindSCPos() {
        return this.pos != null;
    }

    protected void update() {
        this.posList = this.findSCPos(this.FIMBlockPos);
        this.pos = this.isOnlyOneSmelteryController(this.posList) ? this.posList.get(0) : null;
    }

    private List<BlockPos> findSCPos(BlockPos pos) {
        List<BlockPos> posList = PosInfo.getFacingList().stream().filter(f -> this.isSmelteryController(pos, (EnumFacing)f)).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).collect(Collectors.toList());
        return posList;
    }

    private boolean isOnlyOneSmelteryController(List list) {
        int amount = list.size();
        return amount == 1;
    }

    private List<Block> getAllAroundBlocks(BlockPos pos) {
        List<Block> blocks = PosInfo.getAllAmountBlockPosList(pos).stream().map(this::getBlock).collect(Collectors.toList());
        return blocks;
    }

    private boolean isSmelteryController(BlockPos pos, EnumFacing facing) {
        return SCInfo.isSmelteryController(this.getBlock(pos, facing));
    }

    public static boolean isSmelteryController(Block block) {
        return block == TinkerSmeltery.smelteryController;
    }

    private Block getBlock(BlockPos pos) {
        Block block = this.worldObj.func_180495_p(pos).func_177230_c();
        return block;
    }

    private Block getBlock(BlockPos pos, EnumFacing facing) {
        return this.getBlock(pos.func_177972_a(facing));
    }

    public static TileSmeltery getTileSmeltery(World world, BlockPos pos) {
        return (TileSmeltery)world.func_175625_s(pos);
    }

    public boolean isSCHeatingItem() {
        Adapter adap = this.getAdapter();
        return adap.isHeatingItem() && !adap.isAllItemFinishHeating();
    }

    public Adapter getAdapter() {
        return new SCTileAdapter(SCInfo.getTileSmeltery(this.worldObj, this.pos));
    }

    public String getFacing() {
        String facing = PosInfo.getFacingList().stream().filter(f -> this.isSmelteryController(this.FIMBlockPos, (EnumFacing)f)).map(Enum::name).reduce((f, b) -> String.join((CharSequence)", ", f, b)).orElse("NONE");
        return facing;
    }

    public BlockPos getSCpos() {
        return this.pos;
    }
}

