/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity.fim;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tinker_io.TileEntity.TileEntityContainerAdapter;
import tinker_io.TileEntity.fim.Adapter;
import tinker_io.TileEntity.fim.FuelFSM;
import tinker_io.TileEntity.fim.FuelFSMFactory;
import tinker_io.TileEntity.fim.SCInfo;
import tinker_io.TileEntity.fim.SCInfoFactory;
import tinker_io.api.Observable;
import tinker_io.api.Observer;
import tinker_io.reflection.TempField;
import tinker_io.registry.ItemRegistry;

public class FIMTileEntity
extends TileEntityContainerAdapter
implements ITickable,
Observable<Observer> {
    private static final int[] slotsSpeedUPG = new int[]{0};
    private static final int[] slotsFuel = new int[]{1};
    public ItemStack fuel = new ItemStack(ItemRegistry.SolidFuel);
    private List<Observer> obs = new ArrayList<Observer>();
    protected SCInfo scInfo;
    protected FuelFSM fuelFSM = FuelFSMFactory.getNewFuelFSM(this);
    protected int tick = 0;
    public int keepInputTime;
    public int inputTime;
    public int fuelTemp;

    public FIMTileEntity() {
        super(null, 2);
    }

    public void onLoad() {
        this.scInfo = SCInfoFactory.getSmelyeryControllerInfo(this);
        this.fuelFSM.init();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tick % 4 == 0) {
                this.toUpdateSCInfoAndSpeedUpSC();
            }
            this.tick = (this.tick + 1) % 20;
        }
    }

    private void toUpdateSCInfoAndSpeedUpSC() {
        this.scInfo.update();
        this.fuelFSM.func_73660_a();
        if (this.scInfo.canFindSCPos() && this.scInfo.isSCHeatingItem()) {
            this.fuelFSM.startChangeState();
            Adapter adap = this.scInfo.getAdapter();
            int fuelTemp = adap.getFuelTemp();
            this.toSpeedUpSC(fuelTemp, adap);
        }
        if (this.fuelFSM.isActive) {
            this.notifyObservers();
        }
    }

    private void toSpeedUpSC(int originFuelTemp, Adapter adap) {
        double ratio = this.getSpeedUpInfo().ratio;
        int fuelTempWithRatio = this.fuelTemp * (int)ratio;
        int f = fuelTempWithRatio / 2 + originFuelTemp;
        if (fuelTempWithRatio <= 20000) {
            f = fuelTempWithRatio * 6 / 100 + originFuelTemp;
        }
        if (f >= 200000) {
            f = 200000;
        }
        TempField field = new TempField(this.field_145850_b, this.scInfo.getSCpos());
        field.setTemp(f);
    }

    public int getSpeedUpTemp(int originFuelTemp) {
        return TileEntityFurnace.func_145952_a((ItemStack)this.getSlots()[1]) + originFuelTemp;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos neighbor) {
        this.scInfo.manager.onNeighborChange(world, neighbor);
    }

    public int getStackSize(ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    @Override
    public void addObserver(Observer o) {
        this.obs.add(o);
    }

    @Override
    public void removeObserver(Observer o) {
        int index = this.obs.indexOf(o);
        if (index >= 0) {
            this.obs.remove(index);
        }
    }

    @Override
    public void notifyObservers() {
        for (Observer o : this.obs) {
            o.receivedTopic();
        }
    }

    public boolean func_94041_b(int index, ItemStack itemstack) {
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) > 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return slotsFuel;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputTime = tag.func_74765_d("InputTime");
        this.keepInputTime = tag.func_74765_d("keepInputTime");
        this.fuelFSM.readFromNBT(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("InputTime", (short)this.inputTime);
        tag.func_74777_a("keepInputTime", (short)this.keepInputTime);
        this.fuelFSM.writeToNBT(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int pixels) {
        int n = this.inputTime < 0 ? 0 : this.inputTime;
        int i = this.keepInputTime;
        if (i == 0) {
            i = 1000;
        }
        return pixels - n * pixels / i;
    }

    public boolean hasFuel() {
        return this.slots[1] != null && TileEntityFurnace.func_145952_a((ItemStack)this.slots[1]) > 0;
    }

    public SpeedUpRatio getSpeedUpInfo() {
        double temp = (double)this.getStackSize(this.slots[0]) * 0.1 + 1.0;
        return new SpeedUpRatio(temp);
    }

    @SideOnly(value=Side.CLIENT)
    public String getDirection() {
        return this.scInfo.getFacing();
    }

    public int getInputTime() {
        return this.inputTime;
    }

    public static class SpeedUpRatio {
        public double ratio;

        public SpeedUpRatio(double temp) {
            this.ratio = temp;
        }
    }
}

