/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items;

import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.render.ModelT45Boots;
import com.hbm.render.ModelT45Chest;
import com.hbm.render.ModelT45Helmet;
import com.hbm.render.ModelT45Legs;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorT45
extends ItemArmor
implements ISpecialArmor {
    @SideOnly(value=Side.CLIENT)
    private ModelT45Helmet helmet;
    private ModelT45Chest plate;
    private ModelT45Legs legs;
    private ModelT45Boots boots;

    public ArmorT45(ItemArmor.ArmorMaterial armorMaterial, int renderIndex, int armorType) {
        super(armorMaterial, renderIndex, armorType);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        if (stack.func_77973_b() == ModItems.t45_helmet) {
            return armorType == 0;
        }
        if (stack.func_77973_b() == ModItems.t45_plate) {
            return armorType == 1;
        }
        if (stack.func_77973_b() == ModItems.t45_legs) {
            return armorType == 2;
        }
        if (stack.func_77973_b() == ModItems.t45_boots) {
            return armorType == 3;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this == ModItems.t45_helmet && armorSlot == 0) {
            if (this.helmet == null) {
                this.helmet = new ModelT45Helmet();
            }
            return this.helmet;
        }
        if (this == ModItems.t45_plate && armorSlot == 1) {
            if (this.plate == null) {
                this.plate = new ModelT45Chest();
            }
            return this.plate;
        }
        if (this == ModItems.t45_legs && armorSlot == 2) {
            if (this.legs == null) {
                this.legs = new ModelT45Legs();
            }
            return this.legs;
        }
        if (this == ModItems.t45_boots && armorSlot == 3) {
            if (this.boots == null) {
                this.boots = new ModelT45Boots();
            }
            return this.boots;
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == ModItems.t45_helmet) {
            return "hbm:textures/models/T45Helmet.png";
        }
        if (stack.func_77973_b() == ModItems.t45_plate) {
            return "hbm:textures/models/T45Chest.png";
        }
        if (stack.func_77973_b() == ModItems.t45_legs) {
            return "hbm:textures/models/T45Legs.png";
        }
        if (stack.func_77973_b() == ModItems.t45_boots) {
            return "hbm:textures/models/T45Boots.png";
        }
        return "hbm:textures/armor/MaskOfInfamy.png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (player instanceof EntityPlayer && Library.checkArmor((EntityPlayer)player, ModItems.t45_helmet, ModItems.t45_plate, ModItems.t45_legs, ModItems.t45_boots)) {
            if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b || source == DamageSource.field_76379_h || source == DamageSource.field_76369_e || source == DamageSource.field_76367_g || source == DamageSource.field_76376_m || source.func_76352_a()) {
                return new ISpecialArmor.ArmorProperties(1, 1.0, MathHelper.func_76128_c((double)9.99999999E8));
            }
            if (source == DamageSource.field_82729_p || source == DamageSource.field_82728_o) {
                return new ISpecialArmor.ArmorProperties(1, 1.0, MathHelper.func_76128_c((double)10.0));
            }
            if (source == DamageSource.field_76371_c) {
                return new ISpecialArmor.ArmorProperties(1, 1.0, MathHelper.func_76128_c((double)5.0));
            }
            if (source.func_94541_c()) {
                return new ISpecialArmor.ArmorProperties(1, 1.0, MathHelper.func_76128_c((double)10.0));
            }
        }
        return new ISpecialArmor.ArmorProperties(1, 1.0, MathHelper.func_76128_c((double)3.0));
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (slot == 0) {
            return 3;
        }
        if (slot == 1) {
            return 8;
        }
        if (slot == 2) {
            return 6;
        }
        if (slot == 3) {
            return 3;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (source != DamageSource.field_76367_g && source != DamageSource.field_76369_e && source != DamageSource.field_76379_h) {
            stack.func_77972_a(damage * 1, entity);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        if (armor.func_77973_b() == ModItems.t45_plate) {
            if (armor.func_77978_p() == null) {
                armor.func_77982_d(new NBTTagCompound());
                armor.func_77978_p().func_74768_a("charge", 0);
            }
            if (armor.func_77978_p().func_74762_e("charge") <= 0) {
                for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != ModItems.fusion_core || stack.func_77952_i() == stack.func_77958_k() || armor.func_77978_p().func_74762_e("charge") != 0) continue;
                    if (!world.field_72995_K || armor.func_77978_p().func_74762_e("charge") == 0) {
                        // empty if block
                    }
                    if (player.field_70170_p.field_72995_K) continue;
                    int j = stack.func_77952_i();
                    armor.func_77978_p().func_74768_a("charge", stack.func_77958_k() - j);
                    player.field_71071_by.field_70462_a[i] = null;
                    player.func_145747_a((IChatComponent)new ChatComponentText("[Power Armor recharged]"));
                    break;
                }
            }
            if (armor.func_77978_p().func_74762_e("charge") > 0 && Library.checkArmor(player, ModItems.t45_helmet, ModItems.t45_plate, ModItems.t45_legs, ModItems.t45_boots)) {
                armor.func_77978_p().func_74768_a("charge", armor.func_77978_p().func_74762_e("charge") - 1);
            }
        }
        if (Library.checkArmor(player, ModItems.t45_helmet, ModItems.t45_plate, ModItems.t45_legs, ModItems.t45_boots)) {
            if (player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == ModItems.t45_plate && player.field_71071_by.field_70460_b[2].func_77978_p() != null && player.field_71071_by.field_70460_b[2].func_77978_p().func_74762_e("charge") > 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 5, 0, false, false));
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 5, 1, false, false));
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 5, 2, false, false));
                player.func_70690_d(new PotionEffect(Potion.field_76422_e.field_76415_H, 5, 0, false, false));
            } else {
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 5, 1, false, false));
                player.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 5, 0, false, false));
            }
        }
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        if (itemstack.func_77973_b() == ModItems.t45_plate && itemstack.func_77978_p() != null) {
            if (itemstack.func_77978_p().func_74762_e("charge") != 0) {
                list.add("Charge: " + (itemstack.func_77978_p().func_74762_e("charge") / 50 + 1) + "%");
            } else {
                list.add("Charge: " + itemstack.func_77978_p().func_74762_e("charge") / 50 + "%");
            }
        }
    }
}

