/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.explosion.ExplosionNukeGeneric;
import net.minecraft.world.World;

public class ExplosionNukeAdvanced {
    public int posX;
    public int posY;
    public int posZ;
    public int lastposX = 0;
    public int lastposZ = 0;
    public int radius;
    public int radius2;
    public World worldObj;
    private int n = 1;
    private int nlimit;
    private int shell;
    private int leg;
    private int element;
    public float explosionCoefficient = 1.0f;
    public int type = 0;

    public ExplosionNukeAdvanced(int x, int y, int z, World world, int rad, float coefficient, int typ) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.worldObj = world;
        this.radius = rad;
        this.radius2 = this.radius * this.radius;
        this.explosionCoefficient = coefficient;
        this.type = typ;
        this.nlimit = this.radius2 * 4;
    }

    public boolean update() {
        switch (this.type) {
            case 0: {
                this.breakColumn(this.lastposX, this.lastposZ);
                break;
            }
            case 1: {
                this.vapor(this.lastposX, this.lastposZ);
                break;
            }
            case 2: {
                this.waste(this.lastposX, this.lastposZ);
            }
        }
        this.shell = (int)Math.floor((Math.sqrt(this.n) + 1.0) / 2.0);
        int shell2 = this.shell * 2;
        this.leg = (int)Math.floor((this.n - (shell2 - 1) * (shell2 - 1)) / shell2);
        this.element = this.n - (shell2 - 1) * (shell2 - 1) - shell2 * this.leg - this.shell + 1;
        int n = this.leg == 0 ? this.shell : (this.leg == 1 ? -this.element : (this.lastposX = this.leg == 2 ? -this.shell : this.element));
        this.lastposZ = this.leg == 0 ? this.element : (this.leg == 1 ? this.shell : (this.leg == 2 ? -this.element : -this.shell));
        ++this.n;
        return this.n > this.nlimit;
    }

    private void breakColumn(int x, int z) {
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            int y = dist = (int)Math.sqrt(dist);
            while ((float)y > (float)(-dist) / this.explosionCoefficient) {
                ExplosionNukeGeneric.destruction(this.worldObj, this.posX + x, this.posY + y, this.posZ + z);
                --y;
            }
        }
    }

    private void vapor(int x, int z) {
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            for (int y = dist = (int)Math.sqrt(dist); y > -dist; --y) {
                ExplosionNukeGeneric.vaporDest(this.worldObj, this.posX + x, this.posY + y, this.posZ + z);
            }
        }
    }

    private void waste(int x, int z) {
        int dist = this.radius2 - (x * x + z * z);
        if (dist > 0) {
            for (int y = dist = (int)Math.sqrt(dist); y > -dist; --y) {
                ExplosionNukeGeneric.wasteDest(this.worldObj, this.posX + x, this.posY + y, this.posZ + z);
            }
        }
    }
}

