/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.blocks.ModBlocks;
import com.hbm.lib.Library;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ExplosionChaos {
    private static final Random random = new Random();
    private static Random rand = new Random();

    public static void explode(World world, int x, int y, int z, int bombStartStrength) {
        int r = bombStartStrength;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    ExplosionChaos.destruction(world, X, Y, Z);
                }
            }
        }
    }

    public static void spawnExplosion(World world, int x, int y, int z, int bound) {
        for (int i = 0; i < 25; ++i) {
            int randX = random.nextInt(bound);
            int randY = random.nextInt(bound);
            int randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y + randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y - randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y + randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y + randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y - randY), (double)(z + randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y + randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x + randX), (double)(y - randY), (double)(z - randZ), 10.0f, true);
            randX = random.nextInt(bound);
            randY = random.nextInt(bound);
            randZ = random.nextInt(bound);
            world.func_72876_a(null, (double)(x - randX), (double)(y - randY), (double)(z - randZ), 10.0f, true);
        }
    }

    public static void flameDeath(World world, int x, int y, int z, int bound) {
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || !world.func_180495_p(new BlockPos(X, Y, Z)).func_177230_c().isFlammable((IBlockAccess)world, new BlockPos(XX, YY, ZZ), EnumFacing.UP) || world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c() != Blocks.field_150350_a) continue;
                    world.func_175656_a(new BlockPos(X, Y + 1, Z), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public static void burn(World world, int x, int y, int z, int bound) {
        int r = bound;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 || world.func_180495_p(new BlockPos(X, Y + 1, Z)).func_177230_c() != Blocks.field_150350_a) continue;
                    world.func_175656_a(new BlockPos(X, Y + 1, Z), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    public static void destruction(World world, int x, int y, int z) {
        if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != Blocks.field_150357_h && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.reinforced_brick && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.reinforced_sand && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.reinforced_glass && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.reinforced_lamp_on && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() != ModBlocks.reinforced_lamp_off) {
            world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150350_a.func_176223_P());
        }
    }

    public static void cluster(World world, int x, int y, int z, int count, int gravity) {
    }

    public static void schrab(World world, int x, int y, int z, int count, int gravity) {
    }

    public static void nuke(World world, int x, int y, int z, int count) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < 5; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityTNTPrimed fragment = new EntityTNTPrimed(world);
            fragment.field_70159_w = d1;
            fragment.field_70181_x = d2;
            fragment.field_70179_y = d3;
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void frag(World world, int x, int y, int z, int count, boolean flame, Entity shooter) {
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < count; ++i) {
            d1 = rand.nextDouble();
            d2 = rand.nextDouble();
            d3 = rand.nextDouble();
            if (rand.nextInt(2) == 0) {
                d1 *= -1.0;
            }
            if (rand.nextInt(2) == 0) {
                d3 *= -1.0;
            }
            EntityArrow fragment = new EntityArrow(world, (double)x, (double)y, (double)z);
            fragment.field_70159_w = d1;
            fragment.field_70181_x = d2;
            fragment.field_70179_y = d3;
            fragment.field_70250_c = shooter;
            fragment.func_70243_d(true);
            if (flame) {
                fragment.func_70015_d(1000);
            }
            fragment.func_70239_b(2.5);
            world.func_72838_d((Entity)fragment);
        }
    }

    public static void poison(World world, int x, int y, int z, int bombStartStrength) {
        float f = bombStartStrength;
        HashSet hashset = new HashSet();
        double wat = bombStartStrength * 2;
        boolean isOccupied = false;
        bombStartStrength = (int)((float)bombStartStrength * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d7;
            double d6;
            double d5;
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)bombStartStrength;
            if (!(d4 <= 1.0) || !((d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - (double)x) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y) * d6 + (d7 = entity.field_70161_v - (double)z) * d7))) < wat) || entity instanceof EntityPlayer && Library.checkForGasMask((EntityPlayer)entity) || !(entity instanceof EntityLivingBase)) continue;
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 300, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 2400, 2));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 600, 5));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 2400, 2));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76419_f.func_76396_c(), 2400, 2));
        }
        bombStartStrength = (int)f;
    }

    public static void floater(World world, int x, int y, int z, int radi, int height) {
        int r = radi;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22) continue;
                    IBlockState meta = world.func_180495_p(new BlockPos(X, Y, Z));
                    world.func_175656_a(new BlockPos(X, Y, Z), Blocks.field_150350_a.func_176223_P());
                    if (meta.func_177230_c() == Blocks.field_150350_a || world.field_72995_K) continue;
                    world.func_175656_a(new BlockPos(X, Y + height, Z), meta);
                }
            }
        }
    }

    public static void move(World world, int x, int y, int z, int radius, int a, int b, int c) {
        float f = radius;
        HashSet hashset = new HashSet();
        double wat = radius;
        boolean isOccupied = false;
        int rand = 0;
        radius = (int)((float)radius * 2.0f);
        int i = MathHelper.func_76128_c((double)((double)x - wat - 1.0));
        int j = MathHelper.func_76128_c((double)((double)x + wat + 1.0));
        int k = MathHelper.func_76128_c((double)((double)y - wat - 1.0));
        int i2 = MathHelper.func_76128_c((double)((double)y + wat + 1.0));
        int l = MathHelper.func_76128_c((double)((double)z - wat - 1.0));
        int j2 = MathHelper.func_76128_c((double)((double)z + wat + 1.0));
        List list = world.func_72839_b(null, new AxisAlignedBB((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d9;
            Entity entity = (Entity)list.get(i1);
            double d4 = entity.func_70011_f((double)x, (double)y, (double)z) / (double)radius;
            if (!(d4 <= 1.0)) continue;
            double d5 = entity.field_70165_t - (double)x;
            double d6 = entity.field_70163_u + (double)entity.func_70047_e() - (double)y;
            double d7 = entity.field_70161_v - (double)z;
            if (entity instanceof EntityLiving && !(entity instanceof EntitySheep)) {
                rand = random.nextInt(2);
                if (rand == 0) {
                    ((EntityLiving)entity).func_96094_a("Dinnerbone");
                } else {
                    ((EntityLiving)entity).func_96094_a("Grumm");
                }
            }
            if (entity instanceof EntitySheep) {
                ((EntityLiving)entity).func_96094_a("jeb_");
            }
            if (!((d9 = (double)MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7))) < wat)) continue;
            entity.func_70107_b(entity.field_70165_t += (double)a, entity.field_70163_u += (double)b, entity.field_70161_v += (double)c);
        }
        radius = (int)f;
    }

    public static void mirv(World world, double x, double y, double z) {
    }

    public static void plasma(World world, int x, int y, int z, int radius) {
        int r = radius;
        int r2 = r * r;
        int r22 = r2 / 2;
        for (int xx = -r; xx < r; ++xx) {
            int X = xx + x;
            int XX = xx * xx;
            for (int yy = -r; yy < r; ++yy) {
                int Y = yy + y;
                int YY = XX + yy * yy;
                for (int zz = -r; zz < r; ++zz) {
                    int Z = zz + z;
                    int ZZ = YY + zz * zz;
                    if (ZZ >= r22 + world.field_73012_v.nextInt(r22 / 2)) continue;
                }
            }
        }
    }
}

