/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks;

import com.hbm.blocks.MachineNukeFurnace;
import com.hbm.items.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;

public class TileEntityNukeFurnace
extends TileEntity
implements ISidedInventory,
ITickable {
    private ItemStack[] slots = new ItemStack[3];
    public int dualCookTime;
    public int dualPower;
    public static final int maxPower = 1000;
    public static final int processingSpeed = 30;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2};
    private static final int[] slots_side = new int[]{0};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.nukeFurnace";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public boolean hasItemPower(ItemStack itemStack) {
        return TileEntityNukeFurnace.getItemPower(itemStack) > 0;
    }

    private static int getItemPower(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item == ModItems.rod_u238) {
            return 5;
        }
        if (item == ModItems.rod_dual_u238) {
            return 10;
        }
        if (item == ModItems.rod_quad_u238) {
            return 20;
        }
        if (item == ModItems.rod_u235) {
            return 15;
        }
        if (item == ModItems.rod_dual_u235) {
            return 30;
        }
        if (item == ModItems.rod_quad_u235) {
            return 60;
        }
        if (item == ModItems.rod_pu238) {
            return 25;
        }
        if (item == ModItems.rod_dual_pu238) {
            return 50;
        }
        if (item == ModItems.rod_quad_pu238) {
            return 100;
        }
        if (item == ModItems.rod_pu239) {
            return 15;
        }
        if (item == ModItems.rod_dual_pu239) {
            return 30;
        }
        if (item == ModItems.rod_quad_pu239) {
            return 60;
        }
        if (item == ModItems.rod_pu240) {
            return 5;
        }
        if (item == ModItems.rod_dual_pu240) {
            return 10;
        }
        if (item == ModItems.rod_quad_pu240) {
            return 20;
        }
        if (item == ModItems.rod_neptunium) {
            return 15;
        }
        if (item == ModItems.rod_dual_neptunium) {
            return 30;
        }
        if (item == ModItems.rod_quad_neptunium) {
            return 60;
        }
        if (item == ModItems.rod_schrabidium) {
            return 75;
        }
        if (item == ModItems.rod_dual_schrabidium) {
            return 150;
        }
        if (item == ModItems.rod_quad_schrabidium) {
            return 300;
        }
        return 0;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.dualPower = nbt.func_74765_d("powerTime");
        this.dualCookTime = nbt.func_74765_d("CookTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("powerTime", (short)this.dualPower);
        nbt.func_74777_a("cookTime", (short)this.dualCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 30;
    }

    public int getPowerRemainingScaled(int i) {
        return this.dualPower * i / 1000;
    }

    public boolean canProcess() {
        if (this.slots[1] == null) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[1]);
        if (itemStack == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(itemStack)) {
            return false;
        }
        if (this.slots[2].field_77994_a < this.func_70297_j_() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
            return true;
        }
        return this.slots[2].field_77994_a < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[1]);
            if (this.slots[2] == null) {
                this.slots[2] = itemStack.func_77946_l();
            } else if (this.slots[2].func_77969_a(itemStack)) {
                this.slots[2].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 1; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
            --this.dualPower;
        }
    }

    public boolean hasPower() {
        return this.dualPower > 0;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    public void func_73660_a() {
        boolean flag = this.hasPower();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasItemPower(this.slots[0]) && this.dualPower == 0) {
                this.dualPower += TileEntityNukeFurnace.getItemPower(this.slots[0]);
                if (this.slots[0] != null) {
                    flag1 = true;
                    --this.slots[0].field_77994_a;
                    if (this.slots[0].field_77994_a == 0) {
                        this.slots[0] = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
                    }
                }
            }
            if (this.hasPower() && this.canProcess()) {
                ++this.dualCookTime;
                if (this.dualCookTime == 30) {
                    this.dualCookTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.dualCookTime = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
                MachineNukeFurnace.setState(this.dualCookTime > 0, this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return this.slots.length;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index];
            this.slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

