/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.init;

import com.miningmark48.pearcelmod.handler.ConfigurationHandler;
import com.miningmark48.pearcelmod.init.ModBlocks;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, random, chunkX, chunkZ);
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX, chunkZ);
            }
        }
    }

    private void generateNether(World world, Random rand, int x, int z) {
        this.generateOre(ModBlocks.netherPearcelOre, world, rand, x, z, 3, 6, 10, 0, 60, Blocks.field_150424_aL);
        if (ConfigurationHandler.doSpecialWorldGen) {
            this.generateOre(ModBlocks.pearcelFluid, world, rand, x, z, 1, 2, 20, 0, 60, Blocks.field_150424_aL);
            this.generateOre(ModBlocks.taintedPearcel, world, rand, x, z, 3, 15, 20, 0, 60, Blocks.field_150424_aL);
        }
    }

    private void generateSurface(World world, Random rand, int x, int z) {
        this.generateOre(ModBlocks.pearcelOre, world, rand, x, z, 3, 12, 25, 10, 70, Blocks.field_150348_b);
        this.generateOre(ModBlocks.foolsPearcelOre, world, rand, x, z, 3, 5, 10, 10, 50, ModBlocks.pearcelOre);
        this.generateOre(ModBlocks.pearcelMatterOre, world, rand, x, z, 1, 2, 15, 10, 40, Blocks.field_150348_b);
        this.generateOre(ModBlocks.densePearcelOre, world, rand, x, z, 5, 20, 15, 5, 70, Blocks.field_150348_b);
        this.generateOre(ModBlocks.densePearcelMatterOre, world, rand, x, z, 5, 20, 10, 5, 70, Blocks.field_150348_b);
        if (ConfigurationHandler.doSpecialWorldGen) {
            this.generateOre(ModBlocks.pearcelFluid, world, rand, x, z, 1, 2, 10, 3, 60, Blocks.field_150348_b);
            this.generateOre(ModBlocks.pearcelStone, world, rand, x, z, 1, 15, 20, 10, 64, Blocks.field_150348_b);
            this.generateOre(ModBlocks.pearcelSand, world, rand, x, z, 1, 15, 25, 10, 64, (Block)Blocks.field_150354_m);
        }
    }

    private void generateEnd(World world, Random rand, int x, int z) {
        this.generateOre(ModBlocks.pearcelEndStone, world, rand, x, z, 2, 10, 15, 0, 60, Blocks.field_150377_bs);
        this.generateOre(ModBlocks.enderPearcelOre, world, rand, x, z, 3, 12, 10, 0, 60, Blocks.field_150377_bs);
        if (ConfigurationHandler.doSpecialWorldGen) {
            this.generateOre(ModBlocks.pearcelFluid, world, rand, x, z, 1, 2, 20, 0, 60, Blocks.field_150377_bs);
        }
    }

    public void generateOre(Block block, World world, Random random, int chunkX, int chunkZ, int minVeinSize, int maxVeinSize, int chance, int minY, int maxY, Block generateIn) {
        int veinSize = minVeinSize + random.nextInt(maxVeinSize - minVeinSize);
        int heightRange = maxY - minY;
        WorldGenMinable gen = new WorldGenMinable(block, veinSize, generateIn);
        for (int i = 0; i < chance; ++i) {
            int xRand = chunkX * 16 + random.nextInt(16);
            int yRand = random.nextInt(heightRange) + minY;
            int zRand = chunkZ * 16 + random.nextInt(16);
            gen.func_76484_a(world, random, xRand, yRand, zRand);
        }
    }
}

