/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mantle.blocks.abstracts.MultiServantLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tinker_io.handler.SOEliminateList;
import tinker_io.handler.SORecipes;
import tinker_io.mainRegistry.ItemRegistry;

public class SOTileEntity
extends MultiServantLogic
implements IFluidHandler,
ISidedInventory {
    public FluidTank tank;
    public FluidStack otherLiquid;
    public FluidTankInfo[] otherTankInfo = null;
    public ItemStack[] itemStacksSO = new ItemStack[4];
    private static final int[] slotsPattern = new int[]{0};
    private static final int[] slotsProduct = new int[]{1};
    private static final int[] slotsUPGup = new int[]{2};
    private static final int[] slotsUPGdown = new int[]{3};
    int x;
    int y;
    int z;
    int connection = 0;
    public int currentFrozenTime = 0;
    public int frozenTimeMax = 2;
    SORecipes recipes = new SORecipes();
    private String nameSO;

    public void nameASC(String string) {
        this.nameSO = string;
    }

    public SOTileEntity() {
        this.tank = new FluidTank(10000);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return amount;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidAmount() == 0 || this.tank.getFluid().getFluid() == fluid && this.tank.getFluidAmount() < this.tank.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidAmount() > 0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidStack fluid = null;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().copy();
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid, this.tank.getCapacity())};
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.currentFrozenTime = tags.func_74762_e("CurrentFrozenTime");
        if (tags.func_74767_n("hasFluid")) {
            if (tags.func_74762_e("itemID") != 0) {
                this.tank.setFluid(new FluidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount")));
            } else {
                this.tank.setFluid(FluidRegistry.getFluidStack((String)tags.func_74779_i("fluidName"), (int)tags.func_74762_e("amount")));
            }
        } else {
            this.tank.setFluid(null);
        }
        NBTTagList tagList = tags.func_150295_c("Items", 10);
        this.itemStacksSO = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.itemStacksSO.length) continue;
            this.itemStacksSO[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74768_a("CurrentFrozenTime", this.currentFrozenTime);
        FluidStack liquid = this.tank.getFluid();
        tags.func_74757_a("hasFluid", liquid != null);
        if (liquid != null) {
            tags.func_74778_a("fluidName", liquid.getFluid().getName());
            tags.func_74768_a("amount", liquid.amount);
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.itemStacksSO.length; ++i) {
            if (this.itemStacksSO[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.itemStacksSO[i].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tags.func_74782_a("Items", (NBTBase)tagList);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int func_70302_i_() {
        return this.itemStacksSO.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemStacksSO[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemStacksSO[par1] != null) {
            if (this.itemStacksSO[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemStacksSO[par1];
                this.itemStacksSO[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemStacksSO[par1].func_77979_a(par2);
            if (this.itemStacksSO[par1].field_77994_a == 0) {
                this.itemStacksSO[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.itemStacksSO[slot] != null) {
            ItemStack itemstack = this.itemStacksSO[slot];
            this.itemStacksSO[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.itemStacksSO[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.nameSO : StatCollector.func_74838_a((String)"tile.SmartOutput.name");
    }

    public boolean func_145818_k_() {
        return this.nameSO != null && this.nameSO.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public int[] func_94128_d(int par1) {
        return slotsProduct;
    }

    public boolean func_102007_a(int par1, ItemStack itemstack, int par3) {
        return false;
    }

    public boolean func_102008_b(int par1, ItemStack itemstack, int par3) {
        return itemstack != null;
    }

    public int getLiquidAmount(int par1) {
        FluidTankInfo[] info = this.getTankInfo(ForgeDirection.UNKNOWN);
        FluidStack liquid = info[0].fluid;
        int capacity = 0;
        int liquidAmount = 0;
        int bar = 0;
        if (liquid != null && info != null) {
            liquidAmount = liquid.amount;
            capacity = info[0].capacity;
        } else {
            liquidAmount = 0;
            capacity = 0;
        }
        bar = liquidAmount != 0 && capacity != 0 ? (int)Math.floor((double)liquidAmount / (double)capacity * (double)par1) : 0;
        return bar;
    }

    public void getCoord(int x1, int y1, int z1) {
    }

    public int getOutputSize() {
        int size = 1;
        ItemStack slotUPG1 = new ItemStack(ItemRegistry.Upgrade, 1, 1);
        ItemStack slotUPG2 = new ItemStack(ItemRegistry.Upgrade, 1, 2);
        ItemStack slotUPG3 = new ItemStack(ItemRegistry.Upgrade, 1, 3);
        ItemStack slotUPG4 = new ItemStack(ItemRegistry.Upgrade, 1, 4);
        if (this.itemStacksSO[2] != null) {
            if (this.itemStacksSO[2].func_77969_a(slotUPG1)) {
                size += this.itemStacksSO[2].field_77994_a * 1;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG2)) {
                size += this.itemStacksSO[2].field_77994_a * 2;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG3)) {
                size += this.itemStacksSO[2].field_77994_a * 3;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG4)) {
                size += this.itemStacksSO[2].field_77994_a * 4;
            }
        }
        if (this.itemStacksSO[3] != null) {
            if (this.itemStacksSO[3].func_77969_a(slotUPG1)) {
                size += this.itemStacksSO[3].field_77994_a * 1;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG2)) {
                size += this.itemStacksSO[3].field_77994_a * 2;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG3)) {
                size += this.itemStacksSO[3].field_77994_a * 3;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG4)) {
                size += this.itemStacksSO[3].field_77994_a * 4;
            }
        }
        if (size > 64) {
            return 64;
        }
        return size;
    }

    public boolean hasRedstoneUPG() {
        ItemStack redStoneUPG = new ItemStack(ItemRegistry.Upgrade, 1, 5);
        if (this.itemStacksSO[2] != null && this.itemStacksSO[2].func_77969_a(redStoneUPG)) {
            return true;
        }
        return this.itemStacksSO[3] != null && this.itemStacksSO[3].func_77969_a(redStoneUPG);
    }

    public boolean canFrozen() {
        FluidTankInfo[] info = this.getTankInfo(ForgeDirection.UNKNOWN);
        FluidStack liquid = info[0].fluid;
        boolean hasPowered = true;
        boolean canStart = false;
        if (!this.field_145850_b.field_72995_K) {
            int power = this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int strongestsPower = this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            hasPowered = power != 0 || strongestsPower != 0;
        }
        if (this.hasRedstoneUPG()) {
            if (hasPowered) {
                return false;
            }
            canStart = true;
        } else {
            canStart = true;
        }
        if (info != null && liquid != null && this.itemStacksSO[0] != null && canStart && this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]) != null && this.recipes.getCastingFluidCost((FluidStack)liquid, (ItemStack)this.itemStacksSO[0]).amount <= liquid.amount && this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]) != null) {
            ItemStack itemstack = this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]);
            if (this.itemStacksSO[1] != null) {
                int result = this.itemStacksSO[1].field_77994_a + itemstack.field_77994_a;
                return result <= this.getOutputSize() && result <= this.func_70297_j_() && result <= this.itemStacksSO[1].func_77976_d() && this.itemStacksSO[1].func_77969_a(itemstack);
            }
            return true;
        }
        return false;
    }

    public void frozen() {
        FluidTankInfo[] info = this.getTankInfo(ForgeDirection.UNKNOWN);
        FluidStack liquid = info[0].fluid;
        if (this.canFrozen() && info != null) {
            ItemStack itemstack = this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]);
            ItemStack bucket = new ItemStack(Items.field_151133_ar);
            if (this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]) != null && this.recipes.getCastingFluidCost((FluidStack)liquid, (ItemStack)this.itemStacksSO[0]).amount <= liquid.amount) {
                this.drain(ForgeDirection.UNKNOWN, this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]), true);
                if (this.itemStacksSO[1] == null) {
                    this.itemStacksSO[1] = itemstack.func_77946_l();
                } else if (this.itemStacksSO[1].func_77973_b() == itemstack.func_77973_b()) {
                    this.itemStacksSO[1].field_77994_a += itemstack.field_77994_a;
                }
                if (SOEliminateList.eliminatedList().itemNeedToEliminate(this.itemStacksSO[0].toString())) {
                    if (this.itemStacksSO[0].field_77994_a == 1) {
                        this.itemStacksSO[0] = null;
                    } else {
                        --this.itemStacksSO[0].field_77994_a;
                    }
                }
                if (this.recipes.checkPatternForIguanasSupport(this.itemStacksSO[1])) {
                    if (this.itemStacksSO[0].field_77994_a == 1) {
                        this.itemStacksSO[0] = null;
                    } else {
                        --this.itemStacksSO[0].field_77994_a;
                    }
                }
            }
        }
    }

    public void voidLiquid() {
        FluidTankInfo[] info = this.getTankInfo(ForgeDirection.UNKNOWN);
        FluidStack liquid = info[0].fluid;
        if (liquid != null) {
            int amount = liquid.amount;
            int toVoid = this.tank.drain((int)amount, (boolean)false).amount;
            this.tank.drain(toVoid, true);
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFrozenProgressScaled(int par1) {
        return this.currentFrozenTime * par1 / this.frozenTimeMax;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.canFrozen()) {
            if (this.currentFrozenTime >= this.frozenTimeMax) {
                this.currentFrozenTime = 0;
                this.frozen();
            } else {
                ++this.currentFrozenTime;
            }
            this.func_70296_d();
        } else {
            this.currentFrozenTime = 0;
        }
    }
}

