/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.util;

import me.modmuss50.fr.repack.kotlin.jvm.internal.DefaultConstructorMarker;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.util.Check;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public abstract class MemberKindCheck
implements Check {
    @NotNull
    private final String description;

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    private MemberKindCheck(String description) {
        this.description = description;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ MemberKindCheck(@NotNull String description, DefaultConstructorMarker $constructor_marker) {
        this(description);
    }

    public static final class MemberOrExtension
    extends MemberKindCheck {
        public static final MemberOrExtension INSTANCE;

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
            return DescriptorUtilsKt.isExtension(functionDescriptor) || functionDescriptor.getContainingDeclaration() instanceof ClassDescriptor;
        }

        private MemberOrExtension() {
            super("must be a member or an extension", null);
            INSTANCE = this;
        }

        static {
            new MemberOrExtension();
        }
    }

    public static final class Member
    extends MemberKindCheck {
        public static final Member INSTANCE;

        @Override
        public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
            return functionDescriptor.getContainingDeclaration() instanceof ClassDescriptor;
        }

        private Member() {
            super("must be a member", null);
            INSTANCE = this;
        }

        static {
            new Member();
        }
    }
}

