/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.io.InputStream;
import java.util.Map;
import me.modmuss50.fr.repack.kotlin.collections.CollectionsKt;
import me.modmuss50.fr.repack.kotlin.jvm.functions.Function1;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<String, InputStream> loadResource;

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageFragmentDescriptor packageFragmentDescriptor = CollectionsKt.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(packageFragmentDescriptor instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        Map<ClassId, ProtoBuf.Class> map2 = packageFragment.getClassIdToProto();
        if (map2 == null || (map2 = map2.get(classId)) == null) {
            ResourceLoadingClassDataFinder $receiver$iv = this;
            ResourceLoadingClassDataFinder $receiver = $receiver$iv;
            InputStream inputStream = $receiver.loadResource.invoke($receiver.serializedResourcePaths.getClassMetadataPath(classId));
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            map2 = ProtoBuf.Class.parseFrom(stream, $receiver.serializedResourcePaths.getExtensionRegistry());
        }
        Map<ClassId, ProtoBuf.Class> classProto = map2;
        NameResolver nameResolver = packageFragment.getNameResolver();
        Map<ClassId, ProtoBuf.Class> map3 = classProto;
        Intrinsics.checkExpressionValueIsNotNull(map3, "classProto");
        return new ClassDataWithSource(new ClassData(nameResolver, (ProtoBuf.Class)((Object)map3)), null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(serializedResourcePaths, "serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, "loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

