/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import me.modmuss50.fr.repack.kotlin.jvm.internal.DefaultConstructorMarker;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.Flags;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.PackagePartSource;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public abstract class ProtoContainer {
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;

    @NotNull
    public abstract FqName debugFqName();

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    private ProtoContainer(NameResolver nameResolver, TypeTable typeTable) {
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
    }

    public /* synthetic */ ProtoContainer(@NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, DefaultConstructorMarker $constructor_marker) {
        this(nameResolver, typeTable);
    }

    public static final class Class
    extends ProtoContainer {
        @NotNull
        private final ClassId classId;
        @NotNull
        private final ProtoBuf.Class.Kind kind;
        private final boolean isInner;
        @NotNull
        private final ProtoBuf.Class classProto;
        @Nullable
        private final ClassKind outerClassKind;

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final ProtoBuf.Class.Kind getKind() {
            return this.kind;
        }

        public final boolean isInner() {
            return this.isInner;
        }

        @Override
        @NotNull
        public FqName debugFqName() {
            FqName fqName2 = this.classId.asSingleFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.asSingleFqName()");
            return fqName2;
        }

        @NotNull
        public final ProtoBuf.Class getClassProto() {
            return this.classProto;
        }

        @Nullable
        public final ClassKind getOuterClassKind() {
            return this.outerClassKind;
        }

        public Class(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @Nullable ClassKind outerClassKind) {
            Intrinsics.checkParameterIsNotNull(classProto, "classProto");
            Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
            Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
            super(nameResolver, typeTable, null);
            this.classProto = classProto;
            this.outerClassKind = outerClassKind;
            ClassId classId = nameResolver.getClassId(this.classProto.getFqName());
            Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(classProto.fqName)");
            this.classId = classId;
            ProtoBuf.Class.Kind kind = Flags.CLASS_KIND.get(this.classProto.getFlags());
            if (kind == null) {
                kind = ProtoBuf.Class.Kind.CLASS;
            }
            this.kind = kind;
            Boolean bl = Flags.IS_INNER.get(this.classProto.getFlags());
            Intrinsics.checkExpressionValueIsNotNull(bl, "Flags.IS_INNER.get(classProto.flags)");
            this.isInner = bl;
        }
    }

    public static final class Package
    extends ProtoContainer {
        @NotNull
        private final FqName fqName;
        @Nullable
        private final PackagePartSource packagePartSource;

        @Override
        @NotNull
        public FqName debugFqName() {
            return this.fqName;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @Nullable
        public final PackagePartSource getPackagePartSource() {
            return this.packagePartSource;
        }

        public Package(@NotNull FqName fqName2, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, @Nullable PackagePartSource packagePartSource) {
            Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
            Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
            Intrinsics.checkParameterIsNotNull(typeTable, "typeTable");
            super(nameResolver, typeTable, null);
            this.fqName = fqName2;
            this.packagePartSource = packagePartSource;
        }
    }
}

