/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import me.modmuss50.fr.repack.kotlin.Unit;
import me.modmuss50.fr.repack.kotlin._Assertions;
import me.modmuss50.fr.repack.kotlin.collections.CollectionsKt;
import me.modmuss50.fr.repack.kotlin.jvm.functions.Function1;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.Name;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassData;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ClassDataWithSource;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeTable;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class ClassDeserializer {
    private final Function1<ClassKey, ClassDescriptor> classes;
    private final DeserializationComponents components;

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        return this.classes.invoke(new ClassKey(classId, classDataWithSource));
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassDataWithSource classDataWithSource, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deserializeClass");
        }
        if ((n & 2) != 0) {
            classDataWithSource = null;
        }
        return classDeserializer.deserializeClass(classId, classDataWithSource);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassDescriptor createClass(ClassKey key) {
        void sourceElement;
        void nameResolver;
        void classProto;
        DeserializationContext deserializationContext;
        void classData;
        ClassId classId = key.getClassId();
        ClassDescriptor classDescriptor = this.components.getFictitiousClassDescriptorFactory().createClass(classId);
        if (classDescriptor != null) {
            ClassDescriptor $receiver$iv = classDescriptor;
            ClassDescriptor it = $receiver$iv;
            return it;
        }
        ClassDataWithSource classDataWithSource = key.getClassDataWithSource();
        if (classDataWithSource == null) {
            classDataWithSource = this.components.getClassDataFinder().findClassData(classId);
        }
        if (classDataWithSource == null) {
            return null;
        }
        Object $i$a$1 = classDataWithSource;
        ClassData $receiver$iv = ((ClassDataWithSource)$i$a$1).component1();
        SourceElement it = ((ClassDataWithSource)$i$a$1).component2();
        $i$a$1 = null;
        Object var6_8 = classData;
        $i$a$1 = var6_8.component1();
        ProtoBuf.Class $i$f$let = var6_8.component2();
        var6_8 = null;
        if (classId.isNestedClass()) {
            ClassId classId2 = classId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull(classId2, "classId.outerClassId");
            ClassDescriptor classDescriptor2 = ClassDeserializer.deserializeClass$default(this, classId2, null, 2, null);
            if (!(classDescriptor2 instanceof DeserializedClassDescriptor)) {
                classDescriptor2 = null;
            }
            DeserializedClassDescriptor deserializedClassDescriptor = (DeserializedClassDescriptor)classDescriptor2;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            Name name = classId.getShortClassName();
            Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
            if (!outerClass.hasNestedClass$kotlin_core(name)) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            Unit unit;
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName2 = classId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
            List<PackageFragmentDescriptor> fragments2 = packageFragmentProvider.getPackageFragments(fqName2);
            boolean bl = fragments2.size() == 1;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "There should be exactly one package: " + fragments2 + ", class id is " + classId;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            PackageFragmentDescriptor fragment = CollectionsKt.single(fragments2);
            if (fragment instanceof DeserializedPackageFragment) {
                DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)fragment;
                Name name = classId.getShortClassName();
                Intrinsics.checkExpressionValueIsNotNull(name, "classId.shortClassName");
                if (!deserializedPackageFragment.hasTopLevelClass$kotlin_core(name)) {
                    return null;
                }
            }
            ProtoBuf.TypeTable typeTable = classProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull(typeTable, "classProto.typeTable");
            deserializationContext = this.components.createContext(fragment, (NameResolver)nameResolver, new TypeTable(typeTable), null);
        }
        DeserializationContext outerContext = deserializationContext;
        return new DeserializedClassDescriptor(outerContext, (ProtoBuf.Class)classProto, (NameResolver)nameResolver, (SourceElement)sourceElement);
    }

    public ClassDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkParameterIsNotNull(components, "components");
        this.components = components;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key) {
                Intrinsics.checkParameterIsNotNull(key, "key");
                return ClassDeserializer.access$createClass(this.this$0, key);
            }
            {
                this.this$0 = classDeserializer;
                super(1);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, @NotNull ClassKey key) {
        return $this.createClass(key);
    }

    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassDataWithSource classDataWithSource;

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual(this.classId, ((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassDataWithSource getClassDataWithSource() {
            return this.classDataWithSource;
        }

        public ClassKey(@NotNull ClassId classId, @Nullable ClassDataWithSource classDataWithSource) {
            Intrinsics.checkParameterIsNotNull(classId, "classId");
            this.classId = classId;
            this.classDataWithSource = classDataWithSource;
        }
    }
}

