/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.reflect;

import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.reflect.ReflectJavaClassFinderKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaClass;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectJavaPackage;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.text.StringsKt;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class ReflectJavaClassFinder
implements JavaClassFinder {
    private final ClassLoader classLoader;

    @Override
    @Nullable
    public JavaClass findClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName packageFqName = classId.getPackageFqName();
        String relativeClassName = StringsKt.replace$default(classId.getRelativeClassName().asString(), '.', '$', false, 4, null);
        String name = packageFqName.isRoot() ? relativeClassName : packageFqName.asString() + "." + relativeClassName;
        Class<?> klass = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, name);
        return klass != null ? (JavaClass)new ReflectJavaClass(klass) : (JavaClass)null;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return new ReflectJavaPackage(fqName2);
    }

    public ReflectJavaClassFinder(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull(classLoader, "classLoader");
        this.classLoader = classLoader;
    }
}

