/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.components;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import me.modmuss50.fr.repack.kotlin.Unit;
import me.modmuss50.fr.repack.kotlin.jvm.functions.Function1;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.Name;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.OverridingUtil;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ErrorReporter;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class DescriptorResolverUtils {
    private DescriptorResolverUtils() {
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverrides(@NotNull Name name, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor, final @NotNull ErrorReporter errorReporter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (membersFromSupertypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromSupertypes", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (membersFromCurrent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "membersFromCurrent", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "resolveOverrides"));
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "resolveOverrides"));
        }
        final LinkedHashSet result = new LinkedHashSet();
        OverridingUtil.generateOverridesInFunctionGroup(name, membersFromSupertypes, membersFromCurrent, classDescriptor, new OverridingUtil.DescriptorSink(){

            @Override
            public void addFakeOverride(@NotNull CallableMemberDescriptor fakeOverride) {
                if (fakeOverride == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils$1", "addFakeOverride"));
                }
                OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new Function1<CallableMemberDescriptor, Unit>(){

                    @Override
                    public Unit invoke(@NotNull CallableMemberDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils$1$1", "invoke"));
                        }
                        errorReporter.reportCannotInferVisibility(descriptor2);
                        return Unit.INSTANCE;
                    }
                });
                result.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                if (fromSuper == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils$1", "conflict"));
                }
                if (fromCurrent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils$1", "conflict"));
                }
            }
        });
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "resolveOverrides"));
        }
        return linkedHashSet;
    }

    @Nullable
    public static ValueParameterDescriptor getAnnotationParameterByName(@NotNull Name name, @NotNull ClassDescriptor annotationClass) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "getAnnotationParameterByName"));
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "getAnnotationParameterByName"));
        }
        Collection<ConstructorDescriptor> constructors2 = annotationClass.getConstructors();
        if (constructors2.size() != 1) {
            return null;
        }
        for (ValueParameterDescriptor parameter : constructors2.iterator().next().getValueParameters()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public static boolean isObjectMethodInInterface(@NotNull JavaMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "isObjectMethodInInterface"));
        }
        return member.getContainingClass().isInterface() && member instanceof JavaMethod && DescriptorResolverUtils.isObjectMethod((JavaMethod)member);
    }

    public static boolean isObjectMethod(@NotNull JavaMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "isObjectMethod"));
        }
        String name = method.getName().asString();
        if (name.equals("toString") || name.equals("hashCode")) {
            return method.getValueParameters().isEmpty();
        }
        if (name.equals("equals")) {
            return DescriptorResolverUtils.isMethodWithOneParameterWithFqName(method, "java.lang.Object");
        }
        return false;
    }

    private static boolean isMethodWithOneParameterWithFqName(@NotNull JavaMethod method, @NotNull String fqName2) {
        JavaClassifier classifier2;
        JavaType type2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "isMethodWithOneParameterWithFqName"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "me/modmuss50/fr/repack/kotlin/reflect/jvm/internal/impl/load/java/components/DescriptorResolverUtils", "isMethodWithOneParameterWithFqName"));
        }
        List<JavaValueParameter> parameters2 = method.getValueParameters();
        if (parameters2.size() == 1 && (type2 = parameters2.get(0).getType()) instanceof JavaClassifierType && (classifier2 = ((JavaClassifierType)type2).getClassifier()) instanceof JavaClass) {
            FqName classFqName = ((JavaClass)classifier2).getFqName();
            return classFqName != null && classFqName.asString().equals(fqName2);
        }
        return false;
    }
}

