/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.vanilla;

import li.cil.oc.api.driver.EnvironmentAware;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverTileEntity;
import li.cil.oc.integration.ManagedTileEntityEnvironment;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public final class DriverNoteBlock
extends DriverTileEntity
implements EnvironmentAware {
    @Override
    public Class<?> getTileEntityClass() {
        return TileEntityNote.class;
    }

    @Override
    public ManagedEnvironment createEnvironment(World world, BlockPos pos) {
        return new Environment((TileEntityNote)world.func_175625_s(pos));
    }

    @Override
    public Class<? extends li.cil.oc.api.network.Environment> providedEnvironment(ItemStack stack) {
        if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150323_B) {
            return Environment.class;
        }
        return null;
    }

    public static final class Environment
    extends ManagedTileEntityEnvironment<TileEntityNote>
    implements NamedBlock {
        public Environment(TileEntityNote tileEntity) {
            super(tileEntity, "note_block");
        }

        @Override
        public String preferredName() {
            return "note_block";
        }

        @Override
        public int priority() {
            return 0;
        }

        @Callback(direct=true, doc="function():number -- Get the currently set pitch on this note block.")
        public Object[] getPitch(Context context, Arguments args) {
            return new Object[]{((TileEntityNote)this.tileEntity).field_145879_a + 1};
        }

        @Callback(doc="function(value:number) -- Set the pitch for this note block. Must be in the interval [1, 25].")
        public Object[] setPitch(Context context, Arguments args) {
            this.setPitch(args.checkInteger(0));
            return new Object[]{true};
        }

        @Callback(doc="function([pitch:number]):boolean -- Triggers the note block if possible. Allows setting the pitch for to save a tick.")
        public Object[] trigger(Context context, Arguments args) {
            World world;
            Material material;
            if (args.count() > 0 && args.checkAny(0) != null) {
                this.setPitch(args.checkInteger(0));
            }
            boolean canTrigger = (material = (world = ((TileEntityNote)this.tileEntity).func_145831_w()).func_180495_p(((TileEntityNote)this.tileEntity).func_174877_v().func_177984_a()).func_177230_c().func_149688_o()) == Material.field_151579_a;
            ((TileEntityNote)this.tileEntity).func_175108_a(world, ((TileEntityNote)this.tileEntity).func_174877_v());
            return new Object[]{canTrigger};
        }

        private void setPitch(int value) {
            if (value < 1 || value > 25) {
                throw new IllegalArgumentException("invalid pitch");
            }
            ((TileEntityNote)this.tileEntity).field_145879_a = (byte)(value - 1);
            ((TileEntityNote)this.tileEntity).func_70296_d();
        }
    }
}

