/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Callable;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings$;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.common.Loot;
import li.cil.oc.common.init.Items$;
import li.cil.oc.util.Color$;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.convert.WrapAsScala$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class Loot$ {
    public static final Loot$ MODULE$;
    private final String[] containers;
    private final Map<String, Callable<FileSystem>> factories;
    private final Map<String, Tuple2<ItemStack, Object>> globalDisks;
    private final Map<String, Tuple2<ItemStack, Object>> worldDisks;
    private final ArrayBuffer<ItemStack> disksForSampling;
    private final ArrayBuffer<ItemStack> disksForClient;

    static {
        new Loot$();
    }

    public String[] containers() {
        return this.containers;
    }

    public Map<String, Callable<FileSystem>> factories() {
        return this.factories;
    }

    public Map<String, Tuple2<ItemStack, Object>> globalDisks() {
        return this.globalDisks;
    }

    public Map<String, Tuple2<ItemStack, Object>> worldDisks() {
        return this.worldDisks;
    }

    public ArrayBuffer<ItemStack> disksForSampling() {
        return this.disksForSampling;
    }

    public ArrayBuffer<ItemStack> disksForClient() {
        return this.disksForClient;
    }

    public Option<ItemStack> randomDisk(Random rng) {
        return this.disksForSampling().nonEmpty() ? new Some(this.disksForSampling().apply(rng.nextInt(this.disksForSampling().length()))) : None$.MODULE$;
    }

    public ItemStack registerLootDisk(String name, EnumDyeColor color, Callable<FileSystem> factory) {
        String mod = Loader.instance().activeModContainer().getModId();
        OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering loot disk '", "' from mod ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, mod})));
        String modSpecificName = new StringBuilder().append((Object)mod).append((Object)":").append((Object)name).toString();
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a(new StringBuilder().append((Object)Settings$.MODULE$.namespace()).append((Object)"fs.label").toString(), name);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a(new StringBuilder().append((Object)Settings$.MODULE$.namespace()).append((Object)"data").toString(), (NBTBase)data);
        nbt.func_74778_a(new StringBuilder().append((Object)Settings$.MODULE$.namespace()).append((Object)"lootFactory").toString(), modSpecificName);
        nbt.func_74768_a(new StringBuilder().append((Object)Settings$.MODULE$.namespace()).append((Object)"color").toString(), color.func_176767_b());
        ItemStack stack = Items$.MODULE$.get("floppy").createItemStack(1);
        stack.func_77982_d(nbt);
        this.factories().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)modSpecificName), factory));
        return stack.func_77946_l();
    }

    public void init() {
        Predef$.MODULE$.refArrayOps((Object[])this.containers()).foreach((Function1)new Serializable(){

            public final void apply(String container) {
                ChestGenHooks.addItem((String)container, (WeightedRandomChestContent)new Loot());
            }
        });
        Properties list2 = new Properties();
        InputStream listStream = this.getClass().getResourceAsStream(new StringBuilder().append((Object)"/assets/").append((Object)Settings$.MODULE$.resourceDomain()).append((Object)"/loot/loot.properties").toString());
        list2.load(listStream);
        listStream.close();
        this.parseLootDisks(list2, this.globalDisks(), false);
    }

    @SubscribeEvent
    public void initForWorld(WorldEvent.Load e) {
        if (!e.world.field_72995_K && e.world.field_73011_w.func_177502_q() == 0) {
            File listFile;
            File path;
            this.worldDisks().clear();
            this.disksForSampling().clear();
            if (!e.world.field_72995_K && (path = new File(DimensionManager.getCurrentSaveRootDirectory(), new StringBuilder().append((Object)Settings$.MODULE$.savePath()).append((Object)"loot/").toString())).exists() && path.isDirectory() && (listFile = new File(path, "loot.properties")).exists() && listFile.isFile()) {
                try {
                    FileInputStream listStream = new FileInputStream(listFile);
                    Properties list2 = new Properties();
                    list2.load(listStream);
                    listStream.close();
                    this.parseLootDisks(list2, this.worldDisks(), true);
                }
                catch (Throwable throwable) {
                    OpenComputers$.MODULE$.log().warn("Failed opening loot descriptor file in saves folder.");
                }
            }
            this.globalDisks().withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<String, Tuple2<ItemStack, Object>> check$ifrefutable$1) {
                    Tuple2<String, Tuple2<ItemStack, Object>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<String, Tuple2<ItemStack, Object>> x$1) {
                    Tuple2<String, Tuple2<ItemStack, Object>> tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        boolean bl = !Loot$.MODULE$.worldDisks().contains((Object)name);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            }).foreach((Function1)new Serializable(){

                public final Map<String, Tuple2<ItemStack, Object>> apply(Tuple2<String, Tuple2<ItemStack, Object>> x$2) {
                    Tuple2<String, Tuple2<ItemStack, Object>> tuple2 = x$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        Tuple2 entry = (Tuple2)tuple2._2();
                        Map map = (Map)Loot$.MODULE$.worldDisks().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)entry));
                        return map;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.worldDisks().withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<String, Tuple2<ItemStack, Object>> check$ifrefutable$2) {
                    Tuple2 tuple2;
                    Tuple2<String, Tuple2<ItemStack, Object>> tuple22 = check$ifrefutable$2;
                    boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){

                public final void apply(Tuple2<String, Tuple2<ItemStack, Object>> x$3) {
                    Tuple2 tuple2;
                    Tuple2<String, Tuple2<ItemStack, Object>> tuple22 = x$3;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        ItemStack stack = (ItemStack)tuple2._1();
                        int count = tuple2._2$mcI$sp();
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(this, stack){
                            private final ItemStack stack$1;

                            public final ArrayBuffer<ItemStack> apply(int i) {
                                return Loot$.MODULE$.disksForSampling().$plus$eq((Object)this.stack$1);
                            }
                            {
                                this.stack$1 = stack$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple22);
                }
            });
        }
    }

    private void parseLootDisks(Properties list2, Map<String, Tuple2<ItemStack, Object>> acc, boolean external) {
        WrapAsScala$.MODULE$.asScalaSet(list2.stringPropertyNames()).foreach((Function1)new Serializable(list2, acc, external){
            private final Properties list$1;
            private final Map acc$1;
            private final boolean external$1;

            public final Object apply(String key) {
                BoxedUnit boxedUnit;
                String value = this.list$1.getProperty(key);
                try {
                    Map map;
                    String[] stringArray = value.split(":");
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                        String name = (String)((SeqLike)option.get()).apply(0);
                        String count = (String)((SeqLike)option.get()).apply(1);
                        String color = (String)((SeqLike)option.get()).apply(2);
                        map = (Map)this.acc$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Tuple2((Object)Loot$.MODULE$.createLootDisk(name, key, this.external$1, (Option<EnumDyeColor>)Color$.MODULE$.byOreName().get((Object)color)), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(count)).toInt()))));
                    } else {
                        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
                            String name = (String)((SeqLike)option2.get()).apply(0);
                            String count = (String)((SeqLike)option2.get()).apply(1);
                            map = (Map)this.acc$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Tuple2((Object)Loot$.MODULE$.createLootDisk(name, key, this.external$1, Loot$.MODULE$.createLootDisk$default$4()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(count)).toInt()))));
                        } else {
                            map = (Map)this.acc$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Tuple2((Object)Loot$.MODULE$.createLootDisk(value, key, this.external$1, Loot$.MODULE$.createLootDisk$default$4()), (Object)BoxesRunTime.boxToInteger((int)1))));
                        }
                    }
                    boxedUnit = map;
                }
                catch (Throwable throwable) {
                    OpenComputers$.MODULE$.log().warn(new StringBuilder().append((Object)"Bad loot descriptor: ").append((Object)value).toString(), throwable);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.list$1 = list$1;
                this.acc$1 = acc$1;
                this.external$1 = external$1;
            }
        });
    }

    public ItemStack createLootDisk(String name, String path, boolean external, Option<EnumDyeColor> color) {
        Callable<FileSystem> callable = external ? new Callable<FileSystem>(path){
            private final String path$1;

            public FileSystem call() {
                return li.cil.oc.api.FileSystem.asReadOnly(li.cil.oc.api.FileSystem.fromSaveDirectory(new StringBuilder().append((Object)"loot/").append((Object)this.path$1).toString(), 0L, false));
            }
            {
                this.path$1 = path$1;
            }
        } : new Callable<FileSystem>(path){
            private final String path$1;

            public FileSystem call() {
                return li.cil.oc.api.FileSystem.fromClass(OpenComputers$.MODULE$.getClass(), Settings$.MODULE$.resourceDomain(), new StringBuilder().append((Object)"loot/").append((Object)this.path$1).toString());
            }
            {
                this.path$1 = path$1;
            }
        };
        ItemStack stack = this.registerLootDisk(name, (EnumDyeColor)color.getOrElse((Function0)new Serializable(){

            public final EnumDyeColor apply() {
                return EnumDyeColor.SILVER;
            }
        }), callable);
        Object object = external ? BoxedUnit.UNIT : Items$.MODULE$.registerStack(stack, name);
        return stack;
    }

    public Option<EnumDyeColor> createLootDisk$default$4() {
        return None$.MODULE$;
    }

    private Loot$() {
        MODULE$ = this;
        this.containers = (String[])((Object[])new String[]{"dungeonChest", "pyramidDesertyChest", "pyramidJungleChest", "strongholdLibrary"});
        this.factories = Map$.MODULE$.empty();
        this.globalDisks = Map$.MODULE$.empty();
        this.worldDisks = Map$.MODULE$.empty();
        this.disksForSampling = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.disksForClient = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }
}

