/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.core.MCA;
import mca.tile.TileTombstone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;
import radixcore.util.BlockHelper;

public class PacketTombstoneUpdateSet
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketTombstoneUpdateSet, IMessage> {
    private int x;
    private int y;
    private int z;
    private String[] text;

    public PacketTombstoneUpdateSet() {
    }

    public PacketTombstoneUpdateSet(TileTombstone tombstone) {
        this.x = tombstone.func_174877_v().func_177958_n();
        this.y = tombstone.func_174877_v().func_177956_o();
        this.z = tombstone.func_174877_v().func_177952_p();
        this.text = tombstone.signText;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.text = new String[4];
        this.x = byteBuf.readInt();
        this.y = byteBuf.readInt();
        this.z = byteBuf.readInt();
        for (int i = 0; i < 4; ++i) {
            String readText = (String)ByteBufIO.readObject((ByteBuf)byteBuf);
            this.text[i] = readText = readText.equals("@n/a@") ? "" : readText;
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.x);
        byteBuf.writeInt(this.y);
        byteBuf.writeInt(this.z);
        for (String s : this.text) {
            if (s == null || s.isEmpty()) {
                s = "@n/a@";
            }
            ByteBufIO.writeObject((ByteBuf)byteBuf, (Object)s);
        }
    }

    public IMessage onMessage(PacketTombstoneUpdateSet packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketTombstoneUpdateSet packet = (PacketTombstoneUpdateSet)message;
        EntityPlayer player = this.getPlayer(context);
        World world = player.field_70170_p;
        try {
            TileTombstone tombstone = (TileTombstone)BlockHelper.getTileEntity((World)world, (int)packet.x, (int)packet.y, (int)packet.z);
            if (tombstone != null) {
                tombstone.signText = packet.text;
            }
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                MCA.getPacketHandler().sendPacketToAllPlayers(packet);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

