/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mca.ai.AICooking;
import mca.ai.AIFarming;
import mca.ai.AIHunting;
import mca.ai.AIMining;
import mca.ai.AIWoodcutting;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.entity.EntityHuman;
import mca.enums.EnumInteraction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.packets.AbstractPacket;

public class PacketToggleAI
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketToggleAI, IMessage> {
    private int entityId;
    private int interactionId;
    private List<Boolean> booleans;
    private List<Integer> integers;

    public PacketToggleAI() {
    }

    public PacketToggleAI(EntityHuman human, EnumInteraction interaction, Object ... arguments) {
        this.entityId = human.func_145782_y();
        this.interactionId = interaction.getId();
        this.booleans = new ArrayList<Boolean>();
        this.integers = new ArrayList<Integer>();
        for (Object obj : arguments) {
            if (obj.getClass() == Integer.class) {
                this.integers.add((Integer)obj);
                continue;
            }
            if (obj.getClass() != Boolean.class) continue;
            this.booleans.add((Boolean)obj);
        }
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.booleans = new ArrayList<Boolean>();
        this.integers = new ArrayList<Integer>();
        this.entityId = byteBuf.readInt();
        this.interactionId = byteBuf.readInt();
        int numIntegers = byteBuf.readInt();
        for (int numBooleans = byteBuf.readInt(); numBooleans > 0; --numBooleans) {
            this.booleans.add(byteBuf.readBoolean());
        }
        while (numIntegers > 0) {
            this.integers.add(byteBuf.readInt());
            --numIntegers;
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.interactionId);
        byteBuf.writeInt(this.booleans.size());
        byteBuf.writeInt(this.integers.size());
        for (Boolean b : this.booleans) {
            byteBuf.writeBoolean(b.booleanValue());
        }
        for (Integer i : this.integers) {
            byteBuf.writeInt(i.intValue());
        }
    }

    public IMessage onMessage(PacketToggleAI packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketToggleAI packet = (PacketToggleAI)message;
        EntityPlayer player = this.getPlayer(context);
        EntityHuman human = (EntityHuman)player.field_70170_p.func_73045_a(packet.entityId);
        switch (EnumInteraction.fromId(packet.interactionId)) {
            case FARMING: {
                player.func_71029_a((StatBase)ModAchievements.farming);
                human.getAI(AIFarming.class).startFarming(player, packet.integers.get(0), packet.integers.get(1), packet.booleans.get(0));
                break;
            }
            case MINING: {
                player.func_71029_a((StatBase)ModAchievements.mining);
                if (packet.booleans.get(0).booleanValue()) {
                    human.getAI(AIMining.class).startGathering(player);
                    break;
                }
                human.getAI(AIMining.class).startSearching(player, packet.integers.get(0));
                break;
            }
            case WOODCUTTING: {
                player.func_71029_a((StatBase)ModAchievements.woodcutting);
                boolean doReplant = packet.booleans.get(0);
                int mappingId = packet.integers.get(0);
                human.getAI(AIWoodcutting.class).startWoodcutting(player, mappingId, doReplant);
                break;
            }
            case HUNTING: {
                player.func_71029_a((StatBase)ModAchievements.hunting);
                boolean flag = packet.booleans.get(0);
                if (flag) {
                    human.getAI(AIHunting.class).startKilling(player);
                    break;
                }
                human.getAI(AIHunting.class).startTaming(player);
                break;
            }
            case COOKING: {
                human.getAI(AICooking.class).startCooking(player);
            }
        }
    }
}

