/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.ai.AIMood;
import mca.ai.AIProcreate;
import mca.ai.AISleep;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.core.minecraft.ModItems;
import mca.data.PlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumInteraction;
import mca.enums.EnumPersonality;
import mca.items.ItemBaby;
import mca.util.MarriageHandler;
import mca.util.TutorialManager;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.packets.AbstractPacket;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class PacketInteract
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketInteract, IMessage> {
    private int buttonId;
    private int entityId;

    public PacketInteract() {
    }

    public PacketInteract(int buttonId, int entityId) {
        this.buttonId = buttonId;
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.buttonId = byteBuf.readInt();
        this.entityId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.buttonId);
        byteBuf.writeInt(this.entityId);
    }

    public IMessage onMessage(PacketInteract packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketInteract packet = (PacketInteract)message;
        EntityHuman villager = null;
        EntityPlayer player = null;
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            player = this.getPlayer(context);
            villager = (EntityHuman)world.func_73045_a(packet.entityId);
            if (player != null && villager != null) break;
        }
        if (player != null && villager != null) {
            int i;
            EnumInteraction interaction = EnumInteraction.fromId(packet.buttonId);
            if (interaction == EnumInteraction.SET_HOME) {
                if (villager.getAI(AISleep.class).setHomePoint(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v)) {
                    villager.say("interaction.sethome.success", player);
                    TutorialManager.sendMessageToPlayer(player, "Villagers go to their home points at night, and then go to sleep.", "If their home point becomes blocked, they will automatically find a new one.");
                } else {
                    Block block = null;
                    int iPosX = (int)villager.field_70165_t;
                    int iPosY = (int)villager.field_70163_u;
                    int iPosZ = (int)villager.field_70161_v;
                    if (!Utilities.isPointClear(villager.field_70170_p, iPosX, iPosY, iPosZ)) {
                        block = BlockHelper.getBlock((World)villager.field_70170_p, (int)iPosX, (int)iPosY, (int)iPosZ);
                    } else if (!Utilities.isPointClear(villager.field_70170_p, iPosX, iPosY + 1, iPosZ)) {
                        block = BlockHelper.getBlock((World)villager.field_70170_p, (int)iPosX, (int)(iPosY + 1), (int)iPosZ);
                    }
                    if (block != null) {
                        villager.say("interaction.sethome.fail", player, block.func_149732_F().toLowerCase());
                    }
                    TutorialManager.sendMessageToPlayer(player, "Move villagers away from the edges of walls", "and other blocks before setting their home.");
                }
            } else if (interaction == EnumInteraction.TRADE) {
                villager.func_70932_a_(player);
                player.func_180472_a((IMerchant)villager);
            } else if (interaction == EnumInteraction.PICK_UP) {
                villager.func_70078_a((Entity)player);
            } else if (interaction == EnumInteraction.TAKE_GIFT) {
                PlayerMemory memory = villager.getPlayerMemory(player);
                memory.setHasGift(false);
                ItemStack stack = RegistryMCA.getGiftStackFromRelationship(memory.getHearts());
                villager.func_145779_a(stack.func_77973_b(), stack.field_77994_a);
            } else if (interaction == EnumInteraction.CHAT || interaction == EnumInteraction.JOKE || interaction == EnumInteraction.SHAKE_HAND || interaction == EnumInteraction.TELL_STORY || interaction == EnumInteraction.FLIRT || interaction == EnumInteraction.HUG || interaction == EnumInteraction.KISS) {
                AIMood mood = villager.getAI(AIMood.class);
                PlayerMemory memory = villager.getPlayerMemory(player);
                int successChance = interaction.getSuccessChance(villager, memory);
                int pointsModification = interaction.getBasePoints() + villager.getPersonality().getHeartsModifierForInteraction(interaction) + mood.getMood(villager.getPersonality()).getPointsModifierForInteraction(interaction);
                boolean wasGood = RadixLogic.getBooleanWithProbability((int)successChance);
                if (villager.getPersonality() == EnumPersonality.FRIENDLY) {
                    pointsModification = (int)((double)pointsModification + (double)pointsModification * 0.15);
                } else if (villager.getPersonality() == EnumPersonality.FLIRTY) {
                    pointsModification = (int)((double)pointsModification + (double)pointsModification * 0.25);
                } else if (villager.getPersonality() == EnumPersonality.SENSITIVE && RadixLogic.getBooleanWithProbability((int)5)) {
                    pointsModification = -35;
                    wasGood = false;
                } else if (villager.getPersonality() == EnumPersonality.STUBBORN) {
                    pointsModification = (int)((double)pointsModification - (double)pointsModification * 0.15);
                }
                if (wasGood) {
                    pointsModification = RadixMath.clamp((int)pointsModification, (int)1, (int)100);
                    mood.modifyMoodLevel(RadixMath.getNumberInRange((float)0.2f, (float)1.0f));
                    villager.say(memory.getDialogueType().toString() + "." + interaction.getName() + ".good", player);
                } else {
                    pointsModification = RadixMath.clamp((int)(pointsModification * -1), (int)-100, (int)-1);
                    mood.modifyMoodLevel(RadixMath.getNumberInRange((float)0.2f, (float)1.0f) * -1.0f);
                    villager.say(memory.getDialogueType().toString() + "." + interaction.getName() + ".bad", player);
                }
                memory.setHearts(memory.getHearts() + pointsModification);
                memory.increaseInteractionFatigue();
                if (memory.getHearts() >= 100) {
                    player.func_71029_a((StatBase)ModAchievements.fullGoldHearts);
                }
                if (memory.getInteractionFatigue() == 4) {
                    TutorialManager.sendMessageToPlayer(player, "Vilagers tire of conversation after a few tries.", "Talk to them later for better success chances.");
                }
            } else if (interaction == EnumInteraction.STOP) {
                villager.getAIManager().disableAllToggleAIs();
            } else if (interaction == EnumInteraction.INVENTORY) {
                villager.openInventory(player);
            } else if (interaction == EnumInteraction.RIDE_HORSE) {
                if (villager.field_70154_o != null) {
                    EntityHorse horse = (EntityHorse)villager.field_70154_o;
                    horse.func_110251_o(true);
                    villager.func_70078_a(null);
                } else {
                    EntityHorse horse = (EntityHorse)RadixLogic.getNearestEntityOfTypeWithinDistance(EntityHorse.class, (Entity)villager, (int)5);
                    if (horse != null) {
                        if (horse.func_110257_ck() && horse.field_70153_n == null) {
                            villager.func_70078_a((Entity)horse);
                        } else {
                            villager.say("interaction.ridehorse.fail.notrideable", player);
                        }
                    } else {
                        villager.say("interaction.ridehorse.fail.notnearby", player);
                    }
                }
            } else if (interaction == EnumInteraction.DIVORCE) {
                PlayerData data = MCA.getPlayerData(player);
                if (data.getSpousePermanentId() != 0) {
                    villager.say("interaction.divorce.priest.success", player);
                    EntityHuman spouse = MCA.getHumanByPermanentId(data.getSpousePermanentId());
                    if (spouse != null) {
                        MarriageHandler.endMarriage(player, spouse);
                        PlayerMemory memory = spouse.getPlayerMemory(player);
                        spouse.getAI(AIMood.class).modifyMoodLevel(-5.0f);
                        memory.setHearts(-100);
                    }
                    MarriageHandler.forceEndMarriage(player);
                } else {
                    villager.say("interaction.divorce.priest.fail.notmarried", player);
                }
            } else if (interaction == EnumInteraction.RESETBABY) {
                PlayerData data = MCA.getPlayerData(player);
                if (data.getShouldHaveBaby()) {
                    villager.say("interaction.resetbaby.success", player);
                    data.setShouldHaveBaby(false);
                    for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (stack == null || !(stack.func_77973_b() instanceof ItemBaby)) continue;
                        ItemBaby baby = (ItemBaby)stack.func_77973_b();
                        if (!stack.func_77978_p().func_74779_i("owner").equals(player.func_70005_c_())) continue;
                        player.field_71071_by.func_70299_a(i, null);
                    }
                } else {
                    villager.say("interaction.resetbaby.fail", player);
                }
            } else if (interaction == EnumInteraction.ADOPTBABY) {
                PlayerData data = MCA.getPlayerData(player);
                if (this.getIsOverChildrenCount(player)) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7CYou have too many children."));
                } else if (!data.getShouldHaveBaby()) {
                    boolean isMale = RadixLogic.getBooleanWithProbability((int)50);
                    String babyName = isMale ? MCA.getLanguageManager().getString("name.male") : MCA.getLanguageManager().getString("name.female");
                    villager.say("interaction.adoptbaby.success", player, babyName);
                    ItemStack stack = new ItemStack((Item)(isMale ? ModItems.babyBoy : ModItems.babyGirl));
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("name", babyName);
                    nbt.func_74768_a("age", 0);
                    nbt.func_74778_a("owner", player.func_70005_c_());
                    stack.func_77982_d(nbt);
                    player.field_71071_by.func_70441_a(stack);
                    data.setShouldHaveBaby(true);
                } else {
                    villager.say("interactionp.havebaby.fail.alreadyexists", player);
                }
            } else if (interaction == EnumInteraction.ACCEPT) {
                PlayerMemory memory = villager.getPlayerMemory(player);
                memory.setIsHiredBy(true, 3);
                for (i = 0; i < 3; ++i) {
                    player.field_71071_by.func_146026_a(Items.field_151043_k);
                }
            } else if (interaction == EnumInteraction.PROCREATE) {
                PlayerData playerData = MCA.getPlayerData(player);
                if (this.getIsOverChildrenCount(player)) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7CYou have too many children."));
                } else if (playerData.getShouldHaveBaby()) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7CYou already have a baby."));
                } else {
                    villager.getAI(AIProcreate.class).setIsProcreating(true);
                }
            }
        }
    }

    private boolean getIsOverChildrenCount(EntityPlayer player) {
        PlayerData playerData = MCA.getPlayerData(player);
        int childrenCount = 0;
        for (Object obj : MinecraftServer.func_71276_C().field_71305_c[0].field_72996_f) {
            EntityHuman human;
            if (!(obj instanceof EntityHuman) || !(human = (EntityHuman)((Object)obj)).isPlayerAParent(player)) continue;
            ++childrenCount;
        }
        return childrenCount >= MCA.getConfig().childLimit && MCA.getConfig().childLimit != -1;
    }
}

