/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.ai.AIGrow;
import mca.ai.AIMood;
import mca.ai.AIProgressStory;
import mca.api.IGiftableItem;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.core.minecraft.ModItems;
import mca.data.PlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumBabyState;
import mca.enums.EnumProgressionStep;
import mca.util.MarriageHandler;
import mca.util.TutorialManager;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.inventory.Inventory;
import radixcore.packets.AbstractPacket;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class PacketGift
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketGift, IMessage> {
    private int entityId;
    private int slot;

    public PacketGift() {
    }

    public PacketGift(EntityHuman human, int slot) {
        this.entityId = human.func_145782_y();
        this.slot = slot;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.slot = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.slot);
    }

    public IMessage onMessage(PacketGift packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    private boolean handleWeddingRing(EntityPlayer player, EntityHuman human) {
        PlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = human.getPlayerMemory(player);
        if (human.getIsChild() || !human.allowIntimateInteractions(player)) {
            human.say("interaction.give.invalid", player);
        } else if (data.getSpousePermanentId() == human.getPermanentId() && (!human.getIsEngaged() || human.getIsMarried())) {
            human.say("interaction.marry.fail.marriedtogiver", player);
        } else if (human.getIsMarried()) {
            human.say("interaction.marry.fail.marriedtoother", player);
        } else if (human.getIsEngaged() && human.getSpouseId() != data.getPermanentId()) {
            human.say("interaction.engage.fail.engagedtoother", player);
        } else if (data.getSpousePermanentId() != 0 && !data.getIsEngaged()) {
            human.say("interaction.marry.fail.playermarried", player);
        } else if (memory.getHearts() < 95) {
            human.say("interaction.marry.fail.lowhearts", player);
            TutorialManager.sendMessageToPlayer(player, "You must have 5 golden hearts with", "a villager before marrying them.");
        } else {
            player.func_71029_a((StatBase)ModAchievements.marriage);
            human.say("interaction.marry.success", player);
            MarriageHandler.startMarriage(player, human);
            human.getAI(AIMood.class).modifyMoodLevel(3.0f);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
            TutorialManager.sendMessageToPlayer(player, "You are now married. You can have", "children by using the 'Procreate' button.");
            return true;
        }
        return false;
    }

    private boolean handleMatchmakersRing(EntityPlayer player, EntityHuman human, ItemStack stack) {
        EntityHuman partner = (EntityHuman)RadixLogic.getNearestEntityOfTypeWithinDistance(EntityHuman.class, (Entity)human, (int)5);
        if (human.getIsChild()) {
            human.say("interaction.give.invalid", player);
        } else if (human.getIsMarried()) {
            human.say("interaction.matchmaker.fail.married", player);
        } else if (human.getIsEngaged()) {
            human.say("interaction.matchmaker.fail.engaged", player);
        } else if (stack.field_77994_a < 2) {
            human.say("interaction.matchmaker.fail.needtwo", player);
            TutorialManager.sendMessageToPlayer(player, "You must have two matchmaker's rings", "in a stack to arrange a marriage.");
        } else {
            boolean partnerIsValid;
            boolean bl = partnerIsValid = !(partner == null || partner.getIsMarried() || partner.getIsEngaged() || partner.getIsChild() || partner.getFatherId() != -1 && partner.getFatherId() == human.getFatherId() || partner.getMotherId() != -1 && partner.getMotherId() == human.getMotherId());
            if (partner == null) {
                human.say("interaction.matchmaker.fail.novillagers", player);
                TutorialManager.sendMessageToPlayer(player, "To arrange a marriage, have two rings in a stack and ", "make sure another marriable villager is nearby.");
            } else if (!partnerIsValid) {
                human.say("interaction.matchmaker.fail.invalid", player, new Object[]{partner});
                TutorialManager.sendMessageToPlayer(player, "A married villager, relative, or child was too close to this", "villager. Move this villager away from anyone not marriable.");
            } else {
                human.setMarriedTo((Entity)partner);
                partner.setMarriedTo((Entity)human);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)partner, 16);
                for (Object obj : human.field_70170_p.field_73010_i) {
                    EntityPlayer onlinePlayer = (EntityPlayer)obj;
                    if (!human.isPlayerAParent(onlinePlayer) && !partner.isPlayerAParent(onlinePlayer)) continue;
                    onlinePlayer.func_71029_a((StatBase)ModAchievements.childMarried);
                }
                TutorialManager.sendMessageToPlayer(player, "These villagers are now married.", "They will have children in the near future.");
                return true;
            }
        }
        return false;
    }

    private boolean handleEngagementRing(EntityPlayer player, EntityHuman human) {
        PlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = human.getPlayerMemory(player);
        if (human.getIsChild() || !human.allowIntimateInteractions(player)) {
            human.say("interaction.give.invalid", player);
        } else if (data.getSpousePermanentId() == human.getPermanentId()) {
            human.say("interaction.marry.fail.marriedtogiver", player);
        } else if (human.getIsMarried()) {
            human.say("interaction.marry.fail.marriedtoother", player);
        } else if (human.getIsEngaged()) {
            human.say("interaction.engage.fail.engagedtoother", player);
        } else if (data.getSpousePermanentId() != 0) {
            human.say("interaction.marry.fail.playermarried", player);
        } else if (memory.getHearts() < 95) {
            human.say("interaction.marry.fail.lowhearts", player);
            TutorialManager.sendMessageToPlayer(player, "You must have 5 golden hearts with", "a villager before proposing.");
        } else {
            player.func_71029_a((StatBase)ModAchievements.engagement);
            human.say("interaction.engage.success", player);
            MarriageHandler.startEngagement(player, human);
            human.getAI(AIMood.class).modifyMoodLevel(3.0f);
            Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
            TutorialManager.sendMessageToPlayer(player, "You are now engaged. Now gift a wedding ring", "to get gifts from other villagers.");
            return true;
        }
        return false;
    }

    private boolean handleDivorcePapers(EntityPlayer player, EntityHuman human) {
        PlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = human.getPlayerMemory(player);
        if (human.getIsChild()) {
            human.say("interaction.give.invalid", player);
        } else if (!human.getIsMarried()) {
            human.say("interaction.divorce.notmarried", player);
        } else if (human.isMarriedToAPlayer() && data.getSpousePermanentId() != human.getPermanentId()) {
            human.say("interaction.divorce.notmarriedtoplayer", player);
        } else {
            if (human.isMarriedToAPlayer()) {
                memory.setHearts(-100);
                human.say("interaction.divorce.success", player);
                MarriageHandler.endMarriage(player, human);
                human.getAI(AIMood.class).modifyMoodLevel(-10.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_ANGRY, (Entity)human, 16);
            } else {
                EntityHuman partner = human.getVillagerSpouse();
                if (partner != null) {
                    partner.setMarriedTo(null);
                }
                human.setMarriedTo(null);
            }
            return true;
        }
        return false;
    }

    private boolean handleStandardGift(EntityPlayer player, EntityHuman human, int slot, ItemStack stack) {
        int heartsModify;
        int giftValue;
        PlayerMemory memory = human.getPlayerMemory(player);
        Item queryObject = stack.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)stack.func_77973_b()) : stack.func_77973_b();
        int n = giftValue = RegistryMCA.getGiftMap().containsKey(queryObject) ? RegistryMCA.getGiftMap().get(queryObject) : -5;
        if (giftValue == -5 && stack.func_77973_b() instanceof IGiftableItem) {
            IGiftableItem item = (IGiftableItem)stack.func_77973_b();
            giftValue = item.getGiftValue();
        }
        String giftType = (heartsModify = RadixMath.clamp((int)(giftValue - memory.getInteractionFatigue() * 4), (int)-5, (int)Integer.MAX_VALUE)) <= 0 ? "bad" : (heartsModify <= 5 ? "good" : (heartsModify <= 10 ? "better" : "best"));
        memory.setHearts(memory.getHearts() + heartsModify);
        memory.increaseInteractionFatigue();
        human.say(memory.getDialogueType().toString() + ".gift." + giftType, player);
        if (giftValue > 0 && heartsModify <= 0) {
            TutorialManager.sendMessageToPlayer(player, "You have interacted with this villager too much.", "Wait before interacting again.");
        } else if (giftValue <= 0) {
            TutorialManager.sendMessageToPlayer(player, "This villager did not like your gift.", "Try a different item next time.");
        }
        if (heartsModify > 0) {
            human.getAI(AIMood.class).modifyMoodLevel(1.0f);
            return true;
        }
        human.getAI(AIMood.class).modifyMoodLevel(-1.0f);
        return false;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketGift packet = (PacketGift)message;
        EntityHuman human = null;
        EntityPlayer player = null;
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            player = this.getPlayer(context);
            human = (EntityHuman)world.func_73045_a(packet.entityId);
            if (player != null && human != null) break;
        }
        if (player != null && human != null) {
            ItemStack stack = player.field_71071_by.field_70462_a[packet.slot];
            Item item = stack.func_77973_b();
            boolean removeItem = false;
            int removeCount = 1;
            if (item == ModItems.weddingRing || item == ModItems.weddingRingRG) {
                removeItem = this.handleWeddingRing(player, human);
            } else if (item == ModItems.matchmakersRing) {
                removeItem = this.handleMatchmakersRing(player, human, stack);
                removeCount = 2;
            } else if (item == ModItems.engagementRing || item == ModItems.weddingRingRG || item == ModItems.engagementRingRG || item == ModItems.engagementRingHeart || item == ModItems.engagementRingOval || item == ModItems.engagementRingSquare || item == ModItems.engagementRingStar || item == ModItems.engagementRingTiny || item == ModItems.engagementRingTriangle || item == ModItems.engagementRingHeartRG || item == ModItems.engagementRingOvalRG || item == ModItems.engagementRingSquareRG || item == ModItems.engagementRingStarRG || item == ModItems.engagementRingTinyRG || item == ModItems.engagementRingTriangleRG) {
                removeItem = this.handleEngagementRing(player, human);
            } else if (item == ModItems.divorcePapers) {
                removeItem = this.handleDivorcePapers(player, human);
            } else if (human.getIsInfected() && human.func_70660_b(Potion.field_76437_t) != null && stack.func_77973_b() == Items.field_151153_ao) {
                removeItem = true;
                removeCount = 1;
                human.cureInfection();
            } else if (item == Items.field_151153_ao && human.getIsChild() && human.isPlayerAParent(player)) {
                removeItem = true;
                removeCount = 1;
                human.getAI(AIGrow.class).accelerate();
            } else if ((item == ModItems.babyBoy || item == ModItems.babyGirl) && human.getPlayerSpouse() == player) {
                removeItem = true;
                removeCount = 1;
                human.getVillagerInventory().addItemStackToInventory(stack);
            } else if (item == Items.field_151105_aU || Block.func_149634_a((Item)item) == Blocks.field_150414_aQ) {
                EnumProgressionStep step = human.getAI(AIProgressStory.class).getProgressionStep();
                if (human.isMarriedToAVillager() && human.getVillagerSpouse() != null && RadixMath.getDistanceToEntity((Entity)human, (Entity)human.getVillagerSpouse()) <= 8.5) {
                    EntityHuman spouse = human.getVillagerSpouse();
                    removeItem = true;
                    removeCount = 1;
                    if (human.getBabyState() == EnumBabyState.NONE && spouse.getBabyState() == EnumBabyState.NONE) {
                        human.say("gift.cake" + RadixMath.getNumberInRange((int)1, (int)3), player);
                        EntityHuman progressor = !human.getIsMale() ? human : (!spouse.getIsMale() ? spouse : human);
                        human.getAI(AIProgressStory.class).setProgressionStep(EnumProgressionStep.HAD_BABY);
                        spouse.getAI(AIProgressStory.class).setProgressionStep(EnumProgressionStep.HAD_BABY);
                        Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)human, 16);
                        Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.HEART, (Entity)spouse, 16);
                        progressor.setBabyState(EnumBabyState.getRandomGender());
                    } else {
                        human.sayRaw("We already have a baby.", player);
                    }
                    TutorialManager.sendMessageToPlayer(player, "Cake can influence villagers to have children.", "");
                } else if (human.isMarriedToAVillager() && human.getVillagerSpouse() == null) {
                    human.sayRaw("I don't see my spouse anywhere...", player);
                } else {
                    removeCount = 1;
                    removeItem = this.handleStandardGift(player, human, packet.slot, stack);
                }
            } else if (item == ModItems.newOutfit && human.allowControllingInteractions(player)) {
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_HAPPY, (Entity)human, 16);
                human.setClothesTexture(human.getRandomSkin());
                removeItem = true;
                removeCount = 1;
            } else if (item instanceof ItemArmor) {
                removeItem = true;
                removeCount = 1;
                Inventory inventory = human.getVillagerInventory();
                ItemArmor armor = (ItemArmor)item;
                int inventorySlot = 0;
                switch (armor.field_77881_a) {
                    case 0: {
                        inventorySlot = 36;
                        break;
                    }
                    case 1: {
                        inventorySlot = 37;
                        break;
                    }
                    case 2: {
                        inventorySlot = 38;
                        break;
                    }
                    case 3: {
                        inventorySlot = 39;
                    }
                }
                ItemStack stackInArmorSlot = inventory.func_70301_a(inventorySlot);
                if (stackInArmorSlot != null) {
                    human.func_70099_a(stackInArmorSlot, 1.0f);
                }
                inventory.func_70299_a(inventorySlot, stack);
            } else {
                removeItem = this.handleStandardGift(player, human, packet.slot, stack);
            }
            if (removeItem && !player.field_71075_bZ.field_75098_d) {
                stack.field_77994_a -= removeCount;
                if (stack.field_77994_a > 0) {
                    player.field_71071_by.func_70299_a(packet.slot, stack);
                } else {
                    player.field_71071_by.func_70299_a(packet.slot, null);
                }
            }
        }
    }
}

