/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import java.io.Serializable;
import mca.core.MCA;
import mca.data.PlayerData;
import mca.entity.EntityHuman;
import mca.enums.EnumDialogueType;
import mca.enums.EnumRelation;
import mca.packets.PacketSyncPlayerMemory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerMemory
implements Serializable {
    private final transient EntityHuman owner;
    private String playerName;
    private String uuid;
    private int permanentId;
    private int hearts;
    private int hireTimeLeft;
    private int interactionFatigue;
    private boolean hasGift;
    private boolean hasQuest;
    private boolean isHiredBy;
    private EnumDialogueType dialogueType;
    private int feedbackDisplayTime;
    private boolean lastInteractionSuccess;
    private int relationId;
    private transient int timeUntilGreeting;
    private transient int distanceTravelledFrom;
    private int counter;

    public PlayerMemory(EntityHuman owner, EntityPlayer player) {
        this.owner = owner;
        this.playerName = player.func_70005_c_();
        this.uuid = player.func_110124_au().toString();
        this.permanentId = MCA.getPlayerData(player).getPermanentId();
        EnumDialogueType enumDialogueType = this.dialogueType = owner.getIsChild() ? EnumDialogueType.CHILD : EnumDialogueType.ADULT;
        if (owner.getMotherName().equals(this.playerName) || owner.getFatherName().equals(this.playerName)) {
            this.dialogueType = EnumDialogueType.CHILDP;
            this.hearts = 100;
            PlayerData data = MCA.getPlayerData(player);
            data.shouldHaveBaby.setValue((Object)false);
        }
    }

    public PlayerMemory(EntityHuman owner, String username) {
        this.owner = owner;
        this.playerName = username;
    }

    public void writePlayerMemoryToNBT(NBTTagCompound nbt) {
        String nbtPrefix = "playerMemoryValue" + this.playerName;
        nbt.func_74778_a(nbtPrefix + "playerName", this.playerName);
        nbt.func_74778_a(nbtPrefix + "uuid", this.uuid);
        nbt.func_74768_a(nbtPrefix + "permanentId", this.permanentId);
        nbt.func_74768_a(nbtPrefix + "hearts", this.hearts);
        nbt.func_74768_a(nbtPrefix + "timeUntilGreeting", this.timeUntilGreeting);
        nbt.func_74768_a(nbtPrefix + "distanceTraveledFrom", this.distanceTravelledFrom);
        nbt.func_74768_a(nbtPrefix + "hireTimeLeft", this.hireTimeLeft);
        nbt.func_74757_a(nbtPrefix + "hasGift", this.hasGift);
        nbt.func_74768_a(nbtPrefix + "interactionFatigue", this.interactionFatigue);
        nbt.func_74757_a(nbtPrefix + "hasQuest", this.hasQuest);
        nbt.func_74768_a(nbtPrefix + "dialogueType", this.dialogueType.getId());
        nbt.func_74757_a(nbtPrefix + "isHiredBy", this.isHiredBy);
        nbt.func_74768_a(nbtPrefix + "feedbackDisplayTime", this.feedbackDisplayTime);
        nbt.func_74757_a(nbtPrefix + "lastInteractionSuccess", this.lastInteractionSuccess);
        nbt.func_74768_a(nbtPrefix + "relationId", this.relationId);
    }

    public void readPlayerMemoryFromNBT(NBTTagCompound nbt) {
        String nbtPrefix = "playerMemoryValue" + this.playerName;
        this.playerName = nbt.func_74779_i(nbtPrefix + "playerName");
        this.uuid = nbt.func_74779_i(nbtPrefix + "uuid");
        this.permanentId = nbt.func_74762_e(nbtPrefix + "permanentId");
        this.hearts = nbt.func_74762_e(nbtPrefix + "hearts");
        this.timeUntilGreeting = nbt.func_74762_e(nbtPrefix + "timeUntilGreeting");
        this.distanceTravelledFrom = nbt.func_74762_e(nbtPrefix + "distanceTraveledFrom");
        this.hireTimeLeft = nbt.func_74762_e(nbtPrefix + "hireTimeLeft");
        this.hasGift = nbt.func_74767_n(nbtPrefix + "hasGift");
        this.interactionFatigue = nbt.func_74762_e(nbtPrefix + "interactionFatigue");
        this.dialogueType = EnumDialogueType.getById(nbt.func_74762_e(nbtPrefix + "dialogueType"));
        this.hasQuest = nbt.func_74767_n(nbtPrefix + "hasQuest");
        this.isHiredBy = nbt.func_74767_n(nbtPrefix + "isHiredBy");
        this.feedbackDisplayTime = nbt.func_74762_e(nbtPrefix + "feedbackDisplayTime");
        this.lastInteractionSuccess = nbt.func_74767_n(nbtPrefix + "lastInteractionSuccess");
        this.relationId = nbt.func_74762_e(nbtPrefix + "relationId");
    }

    public void doTick() {
        if (this.counter <= 0) {
            this.resetInteractionFatigue();
            if (this.hireTimeLeft > 0) {
                --this.hireTimeLeft;
                if (this.hireTimeLeft <= 0) {
                    this.setIsHiredBy(false, 0);
                    this.owner.getAIManager().disableAllToggleAIs();
                }
            }
            this.counter = 1200;
        }
        --this.counter;
        if (this.feedbackDisplayTime > 0) {
            --this.feedbackDisplayTime;
            if (this.feedbackDisplayTime <= 0) {
                this.onNonTransientValueChanged();
            }
        }
    }

    public int getHearts() {
        return this.hearts;
    }

    public boolean getHasGift() {
        return this.hasGift;
    }

    public int getTimeUntilGreeting() {
        return this.timeUntilGreeting;
    }

    public void setTimeUntilGreeting(int value) {
        this.timeUntilGreeting = value;
    }

    public int getDistanceTraveledFrom() {
        return this.distanceTravelledFrom;
    }

    public void setDistanceTraveledFrom(int value) {
        this.distanceTravelledFrom = value;
    }

    public void setHearts(int value) {
        int delta = (this.hearts - value) * -1;
        this.hearts = value;
        this.setLastInteractionSuccess(delta >= 0);
        this.onNonTransientValueChanged();
    }

    public void setHasQuest(boolean value) {
        this.hasQuest = value;
        this.onNonTransientValueChanged();
    }

    public void setHasGift(boolean value) {
        this.hasGift = value;
        this.onNonTransientValueChanged();
    }

    public void setLastInteractionSuccess(boolean value) {
        this.lastInteractionSuccess = value;
        this.feedbackDisplayTime = 40;
        this.onNonTransientValueChanged();
    }

    public void setDialogueType(EnumDialogueType value) {
        this.dialogueType = value;
        this.onNonTransientValueChanged();
    }

    public EnumDialogueType getDialogueType() {
        return this.dialogueType;
    }

    public boolean doDisplayFeedback() {
        return this.feedbackDisplayTime > 0;
    }

    public boolean getLastInteractionSuccess() {
        return this.lastInteractionSuccess;
    }

    private void onNonTransientValueChanged() {
        if (!MCA.isTesting) {
            EntityPlayerMP player = (EntityPlayerMP)this.owner.field_70170_p.func_72924_a(this.playerName);
            MCA.getPacketHandler().sendPacketToPlayer(new PacketSyncPlayerMemory(this.owner.func_145782_y(), this), player);
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public int getInteractionFatigue() {
        return this.interactionFatigue;
    }

    public void increaseInteractionFatigue() {
        if (MCA.getConfig().enableDiminishingReturns) {
            ++this.interactionFatigue;
            this.onNonTransientValueChanged();
        }
    }

    public void resetInteractionFatigue() {
        this.interactionFatigue = 0;
        this.onNonTransientValueChanged();
    }

    public int getPermanentId() {
        return this.permanentId;
    }

    public String getUUID() {
        return this.uuid;
    }

    public boolean getHasQuest() {
        return this.hasQuest;
    }

    public boolean getIsHiredBy() {
        return this.isHiredBy;
    }

    public void setIsHiredBy(boolean value, int length) {
        this.isHiredBy = value;
        this.hireTimeLeft = length * 60;
        this.onNonTransientValueChanged();
    }

    public void setRelation(EnumRelation relation) {
        this.relationId = relation.getId();
    }

    public EnumRelation getRelation() {
        return EnumRelation.getById(this.relationId);
    }

    public boolean isRelatedToPlayer() {
        return this.relationId > 0;
    }
}

