/*
 * Decompiled with CFR 0.152.
 */
package mca.core.forge;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.items.ItemBaby;
import mca.packets.PacketInteractWithPlayerC;
import mca.util.TutorialManager;
import mca.util.Utilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import radixcore.util.RadixLogic;

public class EventHooksForge {
    @SubscribeEvent
    public void entityJoinedWorldEventHandler(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && MCA.getConfig().canSpawnInDimension(event.world.field_73011_w.func_177502_q())) {
            EntityVillager villager;
            if (event.entity instanceof EntityMob) {
                this.doAddMobTasks((EntityMob)event.entity);
            }
            if (event.entity.getClass() == EntityVillager.class && MCA.getConfig().overwriteOriginalVillagers && (villager = (EntityVillager)event.entity).func_70946_n() >= 0 && villager.func_70946_n() <= 4) {
                villager.func_70096_w().func_75682_a(28, (Object)3577);
            }
        }
    }

    @SubscribeEvent
    public void renderGameOverlayEventHandler(RenderGameOverlayEvent.Text event) {
        TutorialManager.onUpdate();
    }

    private void doAddMobTasks(EntityMob mob) {
        if (MCA.getConfig().allowMobAttacks) {
            if (mob instanceof EntityEnderman) {
                return;
            }
            if (mob instanceof EntityCreeper) {
                mob.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)mob, new Predicate(){

                    public boolean func_179958_a(Entity p_179958_1_) {
                        return p_179958_1_ instanceof EntityHuman;
                    }

                    public boolean apply(Object p_apply_1_) {
                        return this.func_179958_a((Entity)p_apply_1_);
                    }
                }, 6.0f, 1.0, 1.2));
            } else {
                float moveSpeed = 0.7f;
                if (mob instanceof EntitySpider) {
                    moveSpeed = 1.2f;
                } else if (mob instanceof EntitySkeleton) {
                    moveSpeed = 1.1f;
                } else if (mob instanceof EntityZombie) {
                    moveSpeed = 0.9f;
                }
                mob.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)mob, EntityHuman.class, (double)moveSpeed, false));
                mob.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityHuman.class, false));
            }
        } else if (mob.field_70714_bg != null && mob.field_70715_bh.field_75782_a != null) {
            for (int i = 0; i < mob.field_70715_bh.field_75782_a.size(); ++i) {
                try {
                    EntityAITasks.EntityAITaskEntry task = (EntityAITasks.EntityAITaskEntry)mob.field_70715_bh.field_75782_a.get(i);
                    if (!(task.field_75733_a instanceof EntityAINearestAttackableTarget)) continue;
                    EntityAINearestAttackableTarget nat = (EntityAINearestAttackableTarget)task.field_75733_a;
                    for (Field f : nat.getClass().getDeclaredFields()) {
                        if (!f.getType().equals(Class.class)) continue;
                        f.setAccessible(true);
                        Class targetClass = (Class)f.get(nat);
                        f.setAccessible(false);
                        if (!targetClass.isAssignableFrom(EntityVillager.class)) continue;
                        mob.field_70715_bh.func_85156_a((EntityAIBase)nat);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void entityInteractEventHandler(EntityInteractEvent event) {
        if (event.target instanceof EntityHorse) {
            EntityHorse entityHorse = (EntityHorse)event.target;
            if (entityHorse.field_70153_n instanceof EntityHuman) {
                EntityHuman entity = (EntityHuman)entityHorse.field_70153_n;
                entity.func_70085_c(event.entityPlayer);
            }
        } else if (event.target instanceof EntityPlayerMP && !event.entityPlayer.field_70170_p.field_72995_K && !event.entityPlayer.func_70005_c_().contains("[CoFH]")) {
            MCA.getPacketHandler().sendPacketToPlayer(new PacketInteractWithPlayerC(event.entityPlayer, (EntityPlayer)event.target), (EntityPlayerMP)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void worldSaveEventHandler(WorldEvent.Unload event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.func_177502_q() == 0) {
            MCA.getCrashWatcher().checkForCrashReports();
        }
    }

    @SubscribeEvent
    public void playerInteractEventHandler(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70153_n instanceof EntityHuman) {
            event.entityPlayer.field_70153_n.func_70078_a(null);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (MCA.getConfig().enableInfection && event.source != null && event.source.func_76364_f() instanceof EntityZombie) {
            EntityZombie zombie = (EntityZombie)event.source.func_76364_f();
            boolean flag = RadixLogic.getBooleanWithProbability((int)3);
            if (event.entityLiving instanceof EntityPlayer && flag) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null || !(stack.func_77973_b() instanceof ItemBaby)) continue;
                    stack.func_77978_p().func_74757_a("isInfected", true);
                    player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7C" + stack.func_77978_p().func_74779_i("name") + " has been " + "\u00a7A" + "\u00a7l" + "infected" + "\u00a7C" + "!"));
                    player.field_70170_p.func_72956_a((Entity)player, "mob.wither.idle", 0.5f, 1.0f);
                    Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.SPELL_WITCH, (Entity)player, 32);
                }
            } else if (event.entityLiving instanceof EntityHuman && flag) {
                EntityHuman human = (EntityHuman)event.entityLiving;
                human.setIsInfected(true);
                human.func_70606_j(human.func_110138_aP());
                zombie.func_70624_b(null);
                human.field_70170_p.func_72956_a((Entity)human, "mob.wither.idle", 0.5f, 1.0f);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.SPELL_WITCH, (Entity)human, 32);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.entityLiving instanceof EntityMob && event.target instanceof EntityHuman) {
            EntityMob mob = (EntityMob)event.entityLiving;
            EntityHuman target = (EntityHuman)event.target;
            if (target.getIsInfected()) {
                mob.func_70624_b(null);
            }
        }
    }
}

